<?php
require_once '../config.php';

if (!in_array($_SESSION['role'], ['admin', 'teacher'])) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

// Get teacher's ID
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT id FROM staff WHERE user_id = ? AND role = 'teaching'");
$stmt->execute([$user_id]);
$teacher = $stmt->fetch();

if (!$teacher) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Teacher not found']);
    exit;
}

$teacher_id = $teacher['id'];
$student_id = $_GET['student_id'] ?? null;
$class_name = $_GET['class'] ?? null;
$academic_year_id = $_GET['academic_year_id'] ?? null;
$term_id = $_GET['term_id'] ?? null;

if (!$student_id || !$class_name || !$academic_year_id || !$term_id) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing required parameters']);
    exit;
}

// Get courses for this class assigned to the current teacher
// Use teacher_courses table to check assignments
$stmt = $pdo->prepare("
    SELECT DISTINCT c.id, c.code, c.name
    FROM courses c
    JOIN teacher_courses tc ON c.id = tc.course_id
    LEFT JOIN classes cl ON c.class_id = cl.id
    LEFT JOIN class_courses cc ON c.id = cc.course_id
    LEFT JOIN classes cl2 ON cc.class_id = cl2.id
    WHERE (cl.name = ? OR cl2.name = ?) AND tc.teacher_id = ?
    ORDER BY c.name
");
$stmt->execute([$class_name, $class_name, $teacher_id]);
$courses = $stmt->fetchAll();

$grades = [];
foreach ($courses as $course) {
    // Get existing grade for this student, course, term, and academic year
    $stmt = $pdo->prepare("
        SELECT g.grade, g.comments, g.class_score, g.exam_score, g.final_score
        FROM enrollments e
        LEFT JOIN grades g ON e.id = g.enrollment_id AND g.term_id = ? AND g.academic_year_id = ?
        WHERE e.student_id = ? AND e.course_id = ?
    ");
    $stmt->execute([$term_id, $academic_year_id, $student_id, $course['id']]);
    $grade = $stmt->fetch();

    $grades[] = [
        'course_id' => $course['id'],
        'course_name' => $course['name'],
        'course_code' => $course['code'],
        'grade' => $grade ? $grade['grade'] : '',
        'comments' => $grade ? $grade['comments'] : '',
        'class_score' => $grade ? $grade['class_score'] : '',
        'exam_score' => $grade ? $grade['exam_score'] : '',
        'final_score' => $grade ? $grade['final_score'] : ''
    ];
}

header('Content-Type: application/json');
echo json_encode([
    'success' => true,
    'grades' => $grades
]);
?>
