// Pass grading rules from PHP to JavaScript
const gradingRules = <?php echo json_encode($grading_rules); ?>;

// Update the assignGrade function to use dynamic grading rules
function assignGrade(courseId, finalScore) {
    const gradeSelect = document.getElementById(`grade_${courseId}`);
    let grade = '';

    // Use grading rules from database if available
    if (gradingRules && gradingRules.length > 0) {
        for (const rule of gradingRules) {
            if (finalScore >= rule.min_score) {
                grade = rule.grade;
                break;
            }
        }
    } else {
        // Fallback to hardcoded grading system
        if (finalScore >= 95) grade = 'A+';
        else if (finalScore >= 90) grade = 'A';
        else if (finalScore >= 85) grade = 'A-';
        else if (finalScore >= 80) grade = 'B+';
        else if (finalScore >= 75) grade = 'B';
        else if (finalScore >= 70) grade = 'B-';
        else if (finalScore >= 65) grade = 'C+';
        else if (finalScore >= 60) grade = 'C';
        else if (finalScore >= 55) grade = 'C-';
        else if (finalScore >= 50) grade = 'D';
        else grade = 'F';
    }

    gradeSelect.value = grade;
}
