<?php
require_once 'config.php';

try {
    // Check current foreign key
    $stmt = $pdo->query("SELECT CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = 'teacher_classes' AND CONSTRAINT_TYPE = 'FOREIGN KEY'");
    $fk = $stmt->fetchColumn();

    if ($fk) {
        // Drop existing foreign key
        $pdo->exec("ALTER TABLE teacher_classes DROP FOREIGN KEY $fk");
        echo "Dropped existing foreign key: $fk\n";
    }

    // Add new foreign key to staff table
    $pdo->exec("ALTER TABLE teacher_classes ADD CONSTRAINT fk_teacher_classes_staff FOREIGN KEY (teacher_id) REFERENCES staff(id) ON DELETE CASCADE");
    echo "Added new foreign key to staff(id)\n";

    echo "Foreign key updated successfully.\n";
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
