<?php
require_once 'config.php';

try {
    // Get all courses with teacher_id assigned
    $stmt = $pdo->query("SELECT id, teacher_id FROM courses WHERE teacher_id IS NOT NULL");
    $courses_with_teachers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Found " . count($courses_with_teachers) . " courses with teacher_id assigned.\n";

    // Insert into teacher_courses table
    $insert_stmt = $pdo->prepare("INSERT IGNORE INTO teacher_courses (teacher_id, course_id) VALUES (?, ?)");

    $inserted = 0;
    foreach ($courses_with_teachers as $course) {
        $insert_stmt->execute([$course['teacher_id'], $course['id']]);
        if ($insert_stmt->rowCount() > 0) {
            $inserted++;
        }
    }

    echo "Inserted $inserted records into teacher_courses table.\n";

    // Verify the sync
    $stmt = $pdo->query("SELECT COUNT(*) FROM teacher_courses");
    $final_count = $stmt->fetchColumn();
    echo "Final teacher_courses count: $final_count\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
