<?php
require_once 'config.php';

$as_of_date = '2025-10-21';

try {
    echo "Syncing cash_accounts table with journal entry balances...\n\n";

    // Get current balances from journal entries for cash accounts
    $stmt = $pdo->prepare("
        SELECT
            coa.account_name,
            coa.account_code,
            COALESCE(
                SUM(
                    CASE
                        WHEN coa.normal_balance = 'debit' THEN jel.debit_amount - jel.credit_amount
                        ELSE jel.credit_amount - jel.debit_amount
                    END
                ), 0
            ) as journal_balance
        FROM chart_of_accounts coa
        LEFT JOIN journal_entry_lines jel ON coa.id = jel.account_id
        LEFT JOIN journal_entries je ON jel.journal_entry_id = je.id AND je.status = 'posted' AND je.transaction_date <= ?
        WHERE coa.account_type = 'asset'
        AND coa.account_code LIKE '1%'
        AND coa.account_name IN (SELECT account_name FROM cash_accounts)
        GROUP BY coa.id, coa.account_code, coa.account_name, coa.normal_balance
        ORDER BY coa.account_code
    ");
    $stmt->execute([$as_of_date]);
    $journal_balances = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Journal balances for cash accounts:\n";
    foreach ($journal_balances as $balance) {
        echo $balance['account_code'] . ' - ' . $balance['account_name'] . ': ' . number_format($balance['journal_balance'], 2) . "\n";
    }

    echo "\nUpdating cash_accounts table...\n";

    // Update cash_accounts table with journal balances
    foreach ($journal_balances as $balance) {
        $update_stmt = $pdo->prepare("
            UPDATE cash_accounts
            SET current_balance = ?
            WHERE account_name = ?
        ");
        $update_stmt->execute([$balance['journal_balance'], $balance['account_name']]);
        echo "Updated " . $balance['account_name'] . " to " . number_format($balance['journal_balance'], 2) . "\n";
    }

    echo "\nSync complete!\n";

    // Verify the updates
    echo "\nVerification - Current cash_accounts balances:\n";
    $stmt = $pdo->query('SELECT account_name, account_code, current_balance FROM cash_accounts');
    $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach($accounts as $acc) {
        echo $acc['account_code'] . ' - ' . $acc['account_name'] . ': ' . number_format($acc['current_balance'], 2) . "\n";
    }

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
