<?php
require_once '../config.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error = 'Please fill in all fields.';
    } else {
        // Check user credentials
        $stmt = $pdo->prepare("SELECT id, password, role FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $user = $stmt->fetch();

        if ($user && password_verify($password, $user['password'])) {
            // Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $user['role'];

            // Redirect to dashboard
            header('Location: dashboard.php');
            exit;
        } else {
            $error = 'Invalid username or password.';
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subscription Login - School Management System</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #8e44ad 0%, #9b59b6 100%);
            min-height: 100vh;
            margin: 0;
        }

        .top-bar {
            background-color: #fff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            padding: 15px 0;
        }

        .top-bar .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .top-bar .logo {
            font-size: 1.5em;
            font-weight: bold;
            color: #8e44ad;
            display: flex;
            align-items: center;
        }

        .top-bar .logo i {
            margin-right: 10px;
            font-size: 1.8em;
        }

        .main-content {
            padding-top: 80px;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .login-container {
            background-color: #fff;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
            width: 100%;
            max-width: 500px;
        }

        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }

        .login-header .icon {
            font-size: 3em;
            color: #8e44ad;
            margin-bottom: 10px;
        }

        .login-header h1 {
            color: #8e44ad;
            margin-bottom: 10px;
            font-size: 2.5em;
        }

        .login-header p {
            color: #666;
            font-size: 1.1em;
        }

        .form-group {
            margin-bottom: 20px;
            position: relative;
        }

        .form-group .input-icon {
            position: absolute;
            left: 12px;
            top: 50%;
            transform: translateY(-50%);
            padding-top: 5px;
            color: #8e44ad;
            font-size: 16px;
            z-index: 1;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #333;
            font-weight: 500;
        }

        .form-group input {
            width: 100%;
            padding: 12px 12px 12px 40px;
            border: 2px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
            transition: border-color 0.3s ease;
        }

        .form-group input:focus {
            outline: none;
            border-color: #8e44ad;
        }

        .btn {
            display: inline-block;
            padding: 12px 30px;
            background: linear-gradient(135deg, #8e44ad 0%, #9b59b6 100%);
            color: #fff;
            text-decoration: none;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 500;
            width: 100%;
            transition: transform 0.2s ease;
            position: relative;
        }

        .btn .btn-icon {
            margin-right: 8px;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        .error-message {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 5px;
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .back-link {
            text-align: center;
            margin-top: 20px;
        }

        .back-link a {
            color: #8e44ad;
            text-decoration: none;
            font-weight: 500;
        }

        .back-link a:hover {
            text-decoration: underline;
        }

        .demo-info {
            margin-top: 20px;
            padding: 15px;
            background-color: #f8f9ff;
            border-radius: 5px;
            border-left: 4px solid #8e44ad;
        }

        .demo-info h4 {
            margin-bottom: 10px;
            color: #8e44ad;
        }

        .demo-info p {
            margin-bottom: 5px;
            font-size: 0.9em;
            color: #666;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .top-bar .container {
                padding: 0 15px;
            }

            .login-container {
                margin: 20px;
                padding: 30px 20px;
            }

            .login-header h1 {
                font-size: 2em;
            }
        }

        @media (max-width: 480px) {
            .login-container {
                margin: 20px;
                padding: 30px 20px;
            }

            .login-header h1 {
                font-size: 2em;
            }
        }
    </style>
</head>
<body>
    <!-- Top Navigation Bar -->
    <div class="top-bar">
        <div class="container">
            <div class="logo">
                <i class="fas fa-graduation-cap"></i>
                <span>Subscription System</span>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="login-container">
            <div class="login-header">
                <div class="icon"><i class="fas fa-crown"></i></div>
                <h1>Subscription Login</h1>
                <p>Please login to manage your subscription</p>
            </div>

        <?php if ($error): ?>
            <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="post" action="index.php">
            <div class="form-group">
                <label for="username">Username:</label>
                <span class="input-icon" style="margin-top: 13px;"><i class="fas fa-user"></i></span>
                <input type="text" id="username" name="username" required autofocus>
            </div>

            <div class="form-group">
                <label for="password">Password:</label>
                <span class="input-icon" style="margin-top: 13px;"><i class="fas fa-lock"></i></span>
                <input type="password" id="password" name="password" required>
            </div>

            <button type="submit" class="btn"><span class="btn-icon"><i class="fas fa-sign-in-alt"></i></span>Login</button>
        </form>

        <div class="back-link">
            <a href="../index.php">← Back to Main Site</a>
        </div>

        <div class="demo-info">
            <h4>Demo Logins</h4>
            <p><strong>Admin:</strong> Username: admin, Password: admin123</p>
            <p><strong>Teacher:</strong> Username: teacher1, Password: teacher123</p>
            <p><strong>Student:</strong> Username: student1, Password: student123</p>
            <p><strong>Librarian:</strong> Username: librarian1, Password: librarian123</p>
        </div>
        </div>
    </div>

    <script src="../js/script.js"></script>
</body>
</html>
