<?php
require_once 'config.php';

try {
    // Insert sample academic years
    $stmt = $pdo->prepare("INSERT IGNORE INTO academic_years (year, start_date, end_date, is_active) VALUES (?, ?, ?, ?)");
    $stmt->execute(['2023-2024', '2023-09-01', '2024-06-30', false]);
    $stmt->execute(['2024-2025', '2024-09-01', '2025-06-30', true]);
    $stmt->execute(['2025-2026', '2025-09-01', '2026-06-30', false]);

    // Insert sample classes
    $classes = [
        ['Basic 1', 'First year basic education'],
        ['Basic 2', 'Second year basic education'],
        ['Basic 3', 'Third year basic education'],
        ['Basic 4', 'Fourth year basic education'],
        ['Basic 5', 'Fifth year basic education'],
        ['Basic 6', 'Sixth year basic education'],
        ['JHS 1', 'Junior High School Year 1'],
        ['JHS 2', 'Junior High School Year 2'],
        ['JHS 3', 'Junior High School Year 3']
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO classes (name, description) VALUES (?, ?)");
    foreach ($classes as $class) {
        $stmt->execute($class);
    }

    // Insert sample student users
    $student_users = [
        ['john123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['jane123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['michael123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['sarah123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['david123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['emily123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['chris123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['olivia123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['daniel123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['sophia123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['james123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['isabella123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['alex123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['mia123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['ben123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['charlotte123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['william123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['amelia123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['ethan123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['harper123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['mason123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['evelyn123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['logan123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['abigail123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['lucas123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['elizabeth123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['jackson123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['sofia123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['aiden123', password_hash('password123', PASSWORD_DEFAULT), 'student'],
        ['avery123', password_hash('password123', PASSWORD_DEFAULT), 'student']
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO users (username, password, role) VALUES (?, ?, ?)");
    foreach ($student_users as $user) {
        $stmt->execute($user);
    }

    // Insert sample teacher users
    $teacher_users = [
        ['robert123', password_hash('password123', PASSWORD_DEFAULT), 'teacher'],
        ['grace123', password_hash('password123', PASSWORD_DEFAULT), 'teacher'],
        ['kwame123', password_hash('password123', PASSWORD_DEFAULT), 'teacher'],
        ['ama123', password_hash('password123', PASSWORD_DEFAULT), 'teacher'],
        ['samuel123', password_hash('password123', PASSWORD_DEFAULT), 'teacher']
    ];

    foreach ($teacher_users as $user) {
        $stmt->execute($user);
    }

    // Insert sample students
    $students = [
        [4, 'John Doe', 'Basic 1', '2024-2025', '2008-05-15', '123 Main St, Accra', '0241234567', 'John Doe Sr', '0241234568', 'john.doe@email.com'],
        [5, 'Jane Smith', 'Basic 1', '2024-2025', '2008-03-22', '456 Oak Ave, Accra', '0242345678', 'Jane Smith Sr', '0242345679', 'jane.smith@email.com'],
        [6, 'Michael Johnson', 'Basic 1', '2024-2025', '2008-07-10', '789 Pine St, Accra', '0243456789', 'Michael Johnson Sr', '0243456790', 'michael.j@email.com'],
        [7, 'Sarah Wilson', 'Basic 1', '2024-2025', '2008-09-18', '321 Elm St, Accra', '0244567890', 'Sarah Wilson Sr', '0244567891', 'sarah.w@email.com'],
        [8, 'David Brown', 'Basic 1', '2024-2025', '2008-11-25', '654 Maple Ave, Accra', '0245678901', 'David Brown Sr', '0245678902', 'david.b@email.com'],
        [9, 'Emily Davis', 'Basic 2', '2024-2025', '2008-01-30', '987 Cedar St, Accra', '0246789012', 'Emily Davis Sr', '0246789013', 'emily.d@email.com'],
        [10, 'Christopher Miller', 'Basic 2', '2024-2025', '2008-04-12', '147 Birch Ave, Accra', '0247890123', 'Christopher Miller Sr', '0247890124', 'chris.m@email.com'],
        [11, 'Olivia Garcia', 'Basic 2', '2024-2025', '2008-06-28', '258 Walnut St, Accra', '0248901234', 'Olivia Garcia Sr', '0248901235', 'olivia.g@email.com'],
        [12, 'Daniel Rodriguez', 'Basic 2', '2024-2025', '2008-08-14', '369 Chestnut Ave, Accra', '0249012345', 'Daniel Rodriguez Sr', '0249012346', 'daniel.r@email.com'],
        [13, 'Sophia Martinez', 'Basic 2', '2024-2025', '2008-10-20', '741 Spruce St, Accra', '0240123456', 'Sophia Martinez Sr', '0240123457', 'sophia.m@email.com'],
        [14, 'James Anderson', 'Basic 3', '2024-2025', '2007-12-05', '852 Fir Ave, Accra', '0241234567', 'James Anderson Sr', '0241234568', 'james.a@email.com'],
        [15, 'Isabella Thomas', 'Basic 3', '2024-2025', '2007-02-17', '963 Hemlock St, Accra', '0242345678', 'Isabella Thomas Sr', '0242345679', 'isabella.t@email.com'],
        [16, 'Alexander Jackson', 'Basic 3', '2024-2025', '2007-04-23', '159 Poplar Ave, Accra', '0243456789', 'Alexander Jackson Sr', '0243456790', 'alex.j@email.com'],
        [17, 'Mia White', 'Basic 3', '2024-2025', '2007-06-09', '357 Ash St, Accra', '0244567890', 'Mia White Sr', '0244567891', 'mia.w@email.com'],
        [18, 'Benjamin Harris', 'Basic 3', '2024-2025', '2007-08-31', '468 Willow Ave, Accra', '0245678901', 'Benjamin Harris Sr', '0245678902', 'ben.h@email.com'],
        [19, 'Charlotte Clark', 'JHS 1', '2024-2025', '2007-01-16', '579 Hickory St, Accra', '0246789012', 'Charlotte Clark Sr', '0246789013', 'charlotte.c@email.com'],
        [20, 'William Lewis', 'JHS 1', '2024-2025', '2006-03-29', '680 Beech Ave, Accra', '0247890123', 'William Lewis Sr', '0247890124', 'william.l@email.com'],
        [21, 'Amelia Robinson', 'JHS 1', '2024-2025', '2006-05-11', '791 Sycamore St, Accra', '0248901234', 'Amelia Robinson Sr', '0248901235', 'amelia.r@email.com'],
        [22, 'Ethan Walker', 'JHS 1', '2024-2025', '2006-07-24', '802 Dogwood Ave, Accra', '0249012345', 'Ethan Walker Sr', '0249012346', 'ethan.w@email.com'],
        [23, 'Harper Hall', 'JHS 1', '2024-2025', '2006-09-06', '913 Magnolia St, Accra', '0240123456', 'Harper Hall Sr', '0240123457', 'harper.h@email.com'],
        [24, 'Mason Young', 'JHS 2', '2024-2025', '2005-11-19', '024 Redwood Ave, Accra', '0241234567', 'Mason Young Sr', '0241234568', 'mason.y@email.com'],
        [25, 'Evelyn King', 'JHS 2', '2024-2025', '2005-01-02', '135 Sequoia St, Accra', '0242345678', 'Evelyn King Sr', '0242345679', 'evelyn.k@email.com'],
        [26, 'Logan Wright', 'JHS 2', '2024-2025', '2005-03-15', '246 Juniper Ave, Accra', '0243456789', 'Logan Wright Sr', '0243456790', 'logan.w@email.com'],
        [27, 'Abigail Lopez', 'JHS 2', '2024-2025', '2005-05-27', '357 Palm St, Accra', '0244567890', 'Abigail Lopez Sr', '0244567891', 'abigail.l@email.com'],
        [28, 'Lucas Hill', 'JHS 2', '2024-2025', '2005-07-09', '468 Cypress Ave, Accra', '0245678901', 'Lucas Hill Sr', '0245678902', 'lucas.h@email.com'],
        [29, 'Elizabeth Green', 'JHS 3', '2024-2025', '2004-09-21', '579 Acacia St, Accra', '0246789012', 'Elizabeth Green Sr', '0246789013', 'elizabeth.g@email.com'],
        [30, 'Jackson Adams', 'JHS 3', '2024-2025', '2004-11-03', '680 Mahogany Ave, Accra', '0247890123', 'Jackson Adams Sr', '0247890124', 'jackson.a@email.com'],
        [31, 'Sofia Baker', 'JHS 3', '2024-2025', '2004-01-25', '791 Teak St, Accra', '0248901234', 'Sofia Baker Sr', '0248901235', 'sofia.b@email.com'],
        [32, 'Aiden Gonzalez', 'JHS 3', '2024-2025', '2004-04-08', '802 Ebony Ave, Accra', '0249012345', 'Aiden Gonzalez Sr', '0249012346', 'aiden.g@email.com'],
        [33, 'Avery Nelson', 'JHS 3', '2024-2025', '2004-06-20', '913 Ironwood St, Accra', '0240123456', 'Avery Nelson Sr', '0240123457', 'avery.n@email.com']
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO students (user_id, name, class, academic_year, dob, address, phone, parent_name, parent_phone, parent_email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    foreach ($students as $student) {
        $stmt->execute($student);
    }

    // Insert sample teachers
    $teachers = [
        [34, 'Dr. Robert Mensah', 'Mathematics', '0241111111'],
        [35, 'Ms. Grace Osei', 'English', '0242222222'],
        [36, 'Mr. Kwame Asante', 'Science', '0243333333'],
        [37, 'Mrs. Ama Boateng', 'Social Studies', '0244444444'],
        [38, 'Mr. Samuel Nkrumah', 'Physical Education', '0245555555']
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO teachers (user_id, name, subject, phone) VALUES (?, ?, ?, ?)");
    foreach ($teachers as $teacher) {
        $stmt->execute($teacher);
    }

    // Insert sample fees
    $fees = [
        ['Tuition Fee', 'Monthly tuition fee for all students', 150.00, 2, null],
        ['Library Fee', 'Annual library access fee', 25.00, 2, null],
        ['Sports Fee', 'Annual sports and recreational activities fee', 30.00, 2, null],
        ['Basic 1 Tuition', 'Special tuition fee for Basic 1 students', 120.00, 2, 'Basic 1'],
        ['Basic 2 Tuition', 'Special tuition fee for Basic 2 students', 130.00, 2, 'Basic 2'],
        ['JHS Tuition', 'Tuition fee for Junior High School students', 180.00, 2, null],
        ['Computer Lab Fee', 'Access to computer laboratory', 40.00, 2, null],
        ['Art and Craft Fee', 'Materials for art and craft activities', 20.00, 2, null]
    ];

    $stmt = $pdo->prepare("INSERT IGNORE INTO fees (name, description, amount, academic_year_id, class, created_at) VALUES (?, ?, ?, ?, ?, NOW())");
    foreach ($fees as $fee) {
        $stmt->execute($fee);
    }

    echo "Sample data inserted successfully!\n";
    echo "Academic years, classes, students, teachers, and fees have been added to the database.\n";

} catch (PDOException $e) {
    echo "Error inserting sample data: " . $e->getMessage() . "\n";
}
?>
