<?php
require_once 'config.php';

echo "<h1>Setting up Roles and Permissions Tables</h1>";

try {
    // Read and execute the SQL file
    $sql = file_get_contents('admin/create_roles_tables.sql');

    // Split the SQL file into individual statements
    $statements = array_filter(array_map('trim', explode(';', $sql)));

    foreach ($statements as $statement) {
        if (!empty($statement) && !preg_match('/^--/', $statement)) {
            try {
                $pdo->exec($statement);
                echo "<p style='color: green;'>✅ Executed: " . substr($statement, 0, 50) . "...</p>";
            } catch (PDOException $e) {
                echo "<p style='color: orange;'>⚠️ Skipped (might already exist): " . substr($statement, 0, 50) . "... - " . $e->getMessage() . "</p>";
            }
        }
    }

    echo "<h2>✅ Database setup completed!</h2>";
    echo "<p>The roles and permissions tables have been created with default data.</p>";

    // Verify the setup
    echo "<h2>Verification:</h2>";

    $roles_count = $pdo->query("SELECT COUNT(*) FROM roles")->fetchColumn();
    echo "<p><strong>Roles created:</strong> $roles_count</p>";

    $permissions_count = $pdo->query("SELECT COUNT(*) FROM permissions")->fetchColumn();
    echo "<p><strong>Permissions created:</strong> $permissions_count</p>";

    $role_permissions_count = $pdo->query("SELECT COUNT(*) FROM role_permissions")->fetchColumn();
    echo "<p><strong>Role-Permission assignments:</strong> $role_permissions_count</p>";

    echo "<h3>Available Roles:</h3>";
    $roles = $pdo->query("SELECT * FROM roles")->fetchAll();
    foreach ($roles as $role) {
        echo "<div style='margin: 5px 0; padding: 5px; background: #f5f5f5;'>";
        echo "<strong>" . $role['role_name'] . "</strong>";
        if ($role['description']) {
            echo " - " . $role['description'];
        }
        echo "</div>";
    }

    echo "<h3>Key Permissions for Admin/Super Admin:</h3>";
    $key_permissions = $pdo->query("
        SELECT p.permission_name, p.description
        FROM permissions p
        INNER JOIN role_permissions rp ON p.id = rp.permission_id
        INNER JOIN roles r ON rp.role_id = r.id
        WHERE r.role_name IN ('admin', 'super_admin')
        AND p.permission_name IN ('manage_roles', 'manage_user_roles', 'user_management')
    ")->fetchAll();

    foreach ($key_permissions as $perm) {
        echo "<div style='margin: 5px 0; padding: 5px; background: #e8f5e8;'>";
        echo "<strong>" . $perm['permission_name'] . "</strong>";
        if ($perm['description']) {
            echo " - " . $perm['description'];
        }
        echo "</div>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<p><a href='debug_permissions.php'>🔍 Run Permission Debug Tool</a></p>";
?>
