<?php
require_once 'config.php';

try {
    // Remove the admin user from students table
    $stmt = $pdo->prepare("DELETE FROM students WHERE user_id = ? AND name = ''");
    $stmt->execute([1]);

    $affected = $stmt->rowCount();
    echo "Removed $affected admin record(s) from students table.\n";

    // Verify the removal
    $stmt = $pdo->query("SELECT COUNT(*) FROM students");
    $count = $stmt->fetchColumn();
    echo "Remaining students: $count\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
