<?php
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'teacher') {
    header('Location: ../dashboard.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System - Teacher</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
</head>
<body>
    <div class="teacher-container">
        <?php include 'teacher_sidebar.php'; ?>
        <div class="teacher-main">
            <header class="teacher-header">
                <div class="header-content">
                    <button class="mobile-menu-toggle" id="mobile-menu-toggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="header-info">
                        <h1><i class="fas fa-chalkboard-teacher"></i> School Management System</h1>
                        <div class="header-meta">
                            <span class="teacher-badge"><i class="fas fa-user-graduate"></i> Teacher Panel</span>
                            <span class="current-date"><i class="fas fa-calendar"></i> <?php echo date('M d, Y'); ?></span>
                        </div>
                    </div>
                </div>
            </header>

            <main>
<style>
    .teacher-container {
        display: flex;
        min-height: 100vh;
        background-color: #f8f9fa;
    }

    .teacher-main {
        margin-left: 280px;
        flex: 1;
        padding: 20px 20px 20px 0px;
    }

    .teacher-header {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        padding: 15px 20px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        margin-bottom: 20px;
        margin-top: -20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .header-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .mobile-menu-toggle {
        display: none;
        background: white;
        border: 1px solid #ddd;
        font-size: 1.5em;
        color: #f39c12;
        cursor: pointer;
        padding: 10px;
        border-radius: 8px;
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        touch-action: manipulation;
        position: relative;
        z-index: 1031;
    }

    .mobile-menu-toggle:hover {
        background-color: #f8f9fa;
        border-color: #bbb;
        color: #e67e22;
        transform: scale(1.05);
    }

    .mobile-menu-toggle:active {
        transform: scale(0.95);
    }

    .header-info h1 {
        margin: 0 0 5px 0;
        color: #fff;
        font-size: 1.8em;
        font-weight: 600;
    }

    .header-info h1 i {
        color: #fff;
        margin-right: 10px;
    }

    .header-meta {
        display: flex;
        gap: 20px;
        align-items: center;
    }

    .teacher-badge {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: white;
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.85em;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .current-date {
        color: #fff;
        font-size: 0.9em;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .teacher-main main {
        background: white;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 20px;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .teacher-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
        }

        .teacher-sidebar.open {
            transform: translateX(0);
        }

        .teacher-main {
            margin-left: 0;
        }

        .mobile-menu-toggle {
            display: block;
        }

        .header-content {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .header-meta {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }
    }
</style>
