<?php
if (!isset($_SESSION['user_id']) || $_SESSION['role'] != 'student') {
    header('Location: ../login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System - Student</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="../js/mobile_menu.js" defer></script>
</head>
<body>
    <div class="student-container">
        <?php include 'student_sidebar.php'; ?>
        <div class="student-main">
            <header class="student-header">
                <div class="header-content">
                    <button type="button" class="mobile-menu-toggle" id="mobile-menu-toggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="header-info">
                        <h1><i class="fas fa-graduation-cap"></i> School Management System</h1>
                        <div class="header-meta">
                            <span class="student-badge"><i class="fas fa-user-graduate"></i> Student Panel</span>
                            <span class="current-date"><i class="fas fa-calendar"></i> <?php echo date('M d, Y'); ?></span>
                        </div>
                    </div>
                </div>
            </header>

            <main>

<style>
    .student-container {
        display: flex;
        min-height: 100vh;
        background-color: #f8f9fa;
    }

    .student-main {
        margin-left: 280px;
        flex: 1;
        padding: 20px 20px 20px 0px;
        transition: margin-left 0.3s ease;
    }

    .student-header {
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        padding: 15px 20px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        margin-bottom: 20px;
        margin-top: -20px;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        color: white;
        position: relative;
        z-index: 100;
    }
    .header-content {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 15px;
        max-width: 1200px;
        margin: 0 auto;
        padding-left: 60px;
    }
    .mobile-menu-toggle {
        display: none;
        background: rgba(255, 255, 255, 0.1);
        border: 2px solid rgba(255, 255, 255, 0.3);
        font-size: 1.2em;
        color: #fff;
        cursor: pointer;
        padding: 12px 16px;
        border-radius: 8px;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
    }
    .mobile-menu-toggle:hover {
        background: rgba(255, 255, 255, 0.2);
        border-color: rgba(255, 255, 255, 0.5);
        transform: scale(1.05);
    }
    .mobile-menu-toggle:active {
        transform: scale(0.95);
    }
    .header-info h1 {
        margin: 0 0 5px 0;
        color: white;
        font-size: 1.8em;
        font-weight: 600;
    }
    .header-info h1 i {
        color: #ecf0f1;
        margin-right: 10px;
    }
    .header-meta {
        display: flex;
        gap: 20px;
        align-items: center;
    }
    .student-badge {
        background: linear-gradient(135deg, #2980b9 0%, #3498db 100%);
        color: white;
        padding: 5px 12px;
        border-radius: 20px;
        font-size: 0.85em;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 5px;
        box-shadow: 0 2px 4px rgba(41, 128, 185, 0.7);
    }
    .current-date {
        color: #ecf0f1;
        font-size: 0.9em;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .student-main main {
        background: white;
        border-radius: 10px;
        padding: 25px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        margin-bottom: 20px;
        min-height: calc(100vh - 140px);
    }

    /* Mobile Responsive */
    @media (max-width: 768px) {
        .student-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }

        .student-sidebar.open {
            transform: translateX(0);
        }

        .student-main {
            margin-left: 0;
        }

        .mobile-menu-toggle {
            display: block;
        }

        .student-sidebar.open ~ .student-main .mobile-menu-toggle {
            display: none;
        }

        .header-content {
            flex-direction: column;
            align-items: flex-start;
            gap: 15px;
        }

        .header-meta {
            flex-direction: column;
            align-items: flex-start;
            gap: 10px;
        }

        .header-info h1 {
            font-size: 1.5em;
        }

        .student-main main {
            padding: 20px;
            border-radius: 8px;
        }

        .student-header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            margin-top: 0;
            height: auto;
        }

        .student-main {
            padding-top: 80px;
        }
    }

    @media (max-width: 480px) {
        .student-header {
            padding: 12px 15px;
            margin-bottom: 15px;
        }

        .header-info h1 {
            font-size: 1.3em;
        }

        .header-info h1 i {
            margin-right: 8px;
        }

        .student-badge {
            font-size: 0.8em;
            padding: 4px 10px;
        }

        .current-date {
            font-size: 0.85em;
        }

        .student-main {
            padding: 15px 15px 15px 0px;
        }

        .student-main main {
            padding: 15px;
            margin-bottom: 15px;
        }
    }

    @media (max-width: 360px) {
        .header-content {
            gap: 10px;
        }

        .header-info h1 {
            font-size: 1.2em;
        }

        .student-main main {
            padding: 12px;
        }
    }
</style>
