<?php
$user_role = $_SESSION['role'];
$current_page = basename($_SERVER['PHP_SELF']);
?>

<ul class="nav flex-column">
    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'dashboard.php') ? 'active' : ''; ?>" href="../<?php echo $user_role; ?>/dashboard.php">
            <i class="fas fa-tachometer-alt"></i> Dashboard
        </a>
    </li>

    <?php if ($user_role == 'teacher'): ?>
        <!-- Teacher specific menu items -->
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'my_courses.php') ? 'active' : ''; ?>" href="../teacher/my_courses.php">
                <i class="fas fa-book"></i> My Courses
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'assign_grades.php') ? 'active' : ''; ?>" href="../teacher/assign_grades.php">
                <i class="fas fa-graduation-cap"></i> Assign Grades
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'view_payslip.php') ? 'active' : ''; ?>" href="../teacher/view_payslip.php">
                <i class="fas fa-money-bill-wave"></i> View Payslip
            </a>
        </li>
    <?php elseif ($user_role == 'librarian'): ?>
        <!-- Librarian specific menu items -->
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'manage_books.php') ? 'active' : ''; ?>" href="../library/manage_books.php">
                <i class="fas fa-book"></i> Manage Books
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'manage_borrowings.php') ? 'active' : ''; ?>" href="../library/manage_borrowings.php">
                <i class="fas fa-exchange-alt"></i> Borrowings
            </a>
        </li>
    <?php elseif ($user_role == 'non_teaching'): ?>
        <!-- Non-teaching staff menu items -->
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'manage_facilities.php') ? 'active' : ''; ?>" href="../admin/manage_facilities.php">
                <i class="fas fa-building"></i> Facilities
            </a>
        </li>
    <?php elseif ($user_role == 'director'): ?>
        <!-- Director specific menu items -->
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'reports.php') ? 'active' : ''; ?>" href="../admin/reports.php">
                <i class="fas fa-chart-bar"></i> Reports
            </a>
        </li>
    <?php elseif ($user_role == 'head_teacher'): ?>
        <!-- Head teacher specific menu items -->
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'headteacher_dashboard.php') ? 'active' : ''; ?>" href="../admin/headteacher_dashboard.php">
                <i class="fas fa-crown"></i> Admin Dashboard
            </a>
        </li>
    <?php endif; ?>

    <!-- Common menu items for all staff -->
    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'leave_application.php') ? 'active' : ''; ?>" href="../staff/leave_application.php">
            <i class="fas fa-calendar-times"></i> Leave Application
        </a>
    </li>

    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'profile.php') ? 'active' : ''; ?>" href="../profile.php">
            <i class="fas fa-user-edit"></i> Profile
        </a>
    </li>

    <li class="nav-item">
        <a class="nav-link <?php echo ($current_page == 'change_password.php') ? 'active' : ''; ?>" href="../change_password.php">
            <i class="fas fa-key"></i> Change Password
        </a>
    </li>

    <!-- Discussion/Communication for all staff -->
    <?php if ($user_role == 'teacher'): ?>
        <li class="nav-item">
            <a class="nav-link <?php echo ($current_page == 'discussion.php') ? 'active' : ''; ?>" href="../teacher/discussion.php">
                <i class="fas fa-comments"></i> Discussion
            </a>
        </li>
    <?php endif; ?>

    <!-- Logout -->
    <li class="nav-item mt-3">
        <a class="nav-link text-danger" href="../logout.php">
            <i class="fas fa-sign-out-alt"></i> Logout
        </a>
    </li>
</ul>
