<?php
/**
 * Generate a unique student ID using the school short name
 *
 * @param PDO $pdo Database connection
 * @return string Generated student ID
 */
function generate_student_id($pdo) {
    // Get school short name
    $stmt = $pdo->query("SELECT short_name FROM school_settings LIMIT 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
    $short_name = $settings['short_name'] ?? 'SCHOOL';

    // Get the max student ID number (without the short_name prefix)
    $stmt = $pdo->prepare("SELECT MAX(CAST(SUBSTRING(student_id, LENGTH(?) + 1) AS UNSIGNED)) as max_id FROM students WHERE student_id LIKE ?");
    $stmt->execute([$short_name, $short_name . '%']);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $max_id = $result['max_id'] ?? 0;
    $new_id = $max_id + 1;

    return $short_name . str_pad($new_id, 3, '0', STR_PAD_LEFT);
}
?>
