<?php
require_once 'config.php';

try {
    // Check courses table structure
    echo "Courses table structure:\n";
    $stmt = $pdo->query("DESCRIBE courses");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo "- {$col['Field']}: {$col['Type']} " . ($col['Null'] == 'NO' ? 'NOT NULL' : 'NULL') . "\n";
    }

    echo "\nTeacher_courses table structure:\n";
    $stmt = $pdo->query("DESCRIBE teacher_courses");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        echo "- {$col['Field']}: {$col['Type']} " . ($col['Null'] == 'NO' ? 'NOT NULL' : 'NULL') . "\n";
    }

    // Simulate assignment process
    echo "\nSimulating assignment...\n";

    $teacher_id = 1; // Example teacher ID
    $selected_courses = [1, 2]; // Example course IDs

    echo "Teacher ID: $teacher_id\n";
    echo "Selected courses: " . implode(', ', $selected_courses) . "\n";

    // First, remove all current assignments
    echo "Removing current assignments...\n";
    $stmt = $pdo->prepare("UPDATE courses SET teacher_id = NULL WHERE teacher_id = ?");
    $result = $stmt->execute([$teacher_id]);
    echo "UPDATE result: " . ($result ? 'Success' : 'Failed') . ", affected rows: " . $stmt->rowCount() . "\n";

    $stmt = $pdo->prepare("DELETE FROM teacher_courses WHERE teacher_id = ?");
    $result = $stmt->execute([$teacher_id]);
    echo "DELETE result: " . ($result ? 'Success' : 'Failed') . ", affected rows: " . $stmt->rowCount() . "\n";

    // Then assign the selected courses
    if (!empty($selected_courses)) {
        $placeholders = str_repeat('?,', count($selected_courses) - 1) . '?';
        $stmt = $pdo->prepare("UPDATE courses SET teacher_id = ? WHERE id IN ($placeholders)");
        $params = array_merge([$teacher_id], $selected_courses);
        echo "UPDATE query params: " . implode(', ', $params) . "\n";
        $result = $stmt->execute($params);
        echo "UPDATE courses result: " . ($result ? 'Success' : 'Failed') . ", affected rows: " . $stmt->rowCount() . "\n";

        // Also insert into teacher_courses table
        $stmt = $pdo->prepare("INSERT INTO teacher_courses (teacher_id, course_id) VALUES (?, ?)");
        $inserted = 0;
        foreach ($selected_courses as $course_id) {
            $result = $stmt->execute([$teacher_id, $course_id]);
            if ($result) $inserted++;
        }
        echo "INSERT into teacher_courses: $inserted records inserted\n";
    }

    // Check final state
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM courses WHERE teacher_id = ?");
    $stmt->execute([$teacher_id]);
    $courses_count = $stmt->fetchColumn();
    echo "Courses assigned to teacher $teacher_id: $courses_count\n";

    $stmt = $pdo->prepare("SELECT COUNT(*) FROM teacher_courses WHERE teacher_id = ?");
    $stmt->execute([$teacher_id]);
    $tc_count = $stmt->fetchColumn();
    echo "Teacher_courses records for teacher $teacher_id: $tc_count\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
