<?php
require_once 'config.php';

try {
    // Create staff_accounts table
    $sql_staff_accounts = "
        CREATE TABLE IF NOT EXISTS staff_accounts (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100) NOT NULL UNIQUE,
            password VARCHAR(255) NOT NULL,
            status ENUM('active', 'inactive') DEFAULT 'active',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    $pdo->exec($sql_staff_accounts);
    echo "staff_accounts table created successfully.\n";

    // Create staff table
    $sql_staff = "
        CREATE TABLE IF NOT EXISTS staff (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            username VARCHAR(100) NOT NULL,
            password VARCHAR(255) NOT NULL,
            role VARCHAR(50) NOT NULL,
            first_name VARCHAR(100) NOT NULL,
            middle_name VARCHAR(100),
            last_name VARCHAR(100) NOT NULL,
            dob DATE,
            gender ENUM('male', 'female', 'other'),
            address TEXT,
            email VARCHAR(150),
            phone VARCHAR(20),
            ghana_card_number VARCHAR(20),
            qualification VARCHAR(255),
            job_position VARCHAR(100),
            staff_rank VARCHAR(50),
            hire_date DATE,
            profile_image VARCHAR(255),
            staff_id VARCHAR(20) UNIQUE,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES staff_accounts(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
    ";

    $pdo->exec($sql_staff);
    echo "staff table created successfully.\n";

    // Add indexes for better performance
    try {
        $pdo->exec("CREATE INDEX idx_staff_user_id ON staff(user_id)");
    } catch (Exception $e) {
        // Index might already exist, continue
    }

    try {
        $pdo->exec("CREATE INDEX idx_staff_role ON staff(role)");
    } catch (Exception $e) {
        // Index might already exist, continue
    }

    try {
        $pdo->exec("CREATE INDEX idx_staff_accounts_username ON staff_accounts(username)");
    } catch (Exception $e) {
        // Index might already exist, continue
    }

    try {
        $pdo->exec("CREATE INDEX idx_staff_accounts_status ON staff_accounts(status)");
    } catch (Exception $e) {
        // Index might already exist, continue
    }

    echo "Indexes created successfully.\n";

    echo "All staff tables and indexes created successfully!\n";

} catch (PDOException $e) {
    echo "Error creating tables: " . $e->getMessage() . "\n";
}
?>
