<?php
require_once 'config.php';

try {
    echo "Starting students table cleanup...\n";

    // First, backup current data
    echo "Backing up current student data...\n";
    $stmt = $pdo->query("SELECT * FROM students");
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Create backup table
    $pdo->exec("CREATE TABLE students_backup AS SELECT * FROM students");

    echo "Backup created. Found " . count($students) . " student records.\n";

    // Remove unnecessary columns
    $columns_to_drop = [
        'name', // replaced by first_name, middle_name, last_name
        'address', // replaced by home_* fields
        'parent_name', // moved to parents table
        'parent_phone', // moved to parents table
        'parent_email', // moved to parents table
        'sex', // replaced by gender
        'blood_group', // not in new form
        'emergency_contact_name', // moved to emergency_contacts table
        'emergency_contact_phone', // moved to emergency_contacts table
        'medical_conditions', // not in new form
        'ethnicity', // not in new form
        'language_spoken' // replaced by languages_home
    ];

    foreach ($columns_to_drop as $column) {
        try {
            $pdo->exec("ALTER TABLE students DROP COLUMN `$column`");
            echo "Dropped column: $column\n";
        } catch (Exception $e) {
            echo "Could not drop column $column: " . $e->getMessage() . "\n";
        }
    }

    // Check if all required columns exist
    $required_columns = [
        'first_name', 'middle_name', 'last_name', 'gender', 'place_of_birth_city',
        'place_of_birth_country', 'home_street', 'home_city', 'home_state',
        'home_postal', 'home_country', 'previous_school_name', 'previous_school_address',
        'term_admission', 'languages_home'
    ];

    $stmt = $pdo->query("DESCRIBE students");
    $existing_columns = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);

    foreach ($required_columns as $column) {
        if (!in_array($column, $existing_columns)) {
            echo "Warning: Required column '$column' does not exist!\n";
        }
    }

    echo "Cleanup completed. Students table now matches the enrollment form structure.\n";
    echo "Backup table 'students_backup' contains the original data.\n";

} catch (Exception $e) {
    echo "Error during cleanup: " . $e->getMessage() . "\n";
}
?>
