<?php
require_once 'config.php';

try {
    // Check for duplicate students by name
    $stmt = $pdo->query("
        SELECT
            first_name,
            middle_name,
            last_name,
            class,
            academic_year,
            COUNT(*) as count
        FROM students
        GROUP BY first_name, middle_name, last_name, class, academic_year
        HAVING COUNT(*) > 1
        ORDER BY count DESC, last_name, first_name
    ");
    $duplicates = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Duplicate students found:\n";
    if (empty($duplicates)) {
        echo "No duplicate students found.\n";
    } else {
        foreach ($duplicates as $dup) {
            echo "- {$dup['first_name']} {$dup['middle_name']} {$dup['last_name']} (Class: {$dup['class']}, Year: {$dup['academic_year']}) - {$dup['count']} records\n";
        }
    }

    // Check specifically for Elisha Awonseba Ayakpagi
    $stmt = $pdo->prepare("
        SELECT
            s.id,
            s.first_name,
            s.middle_name,
            s.last_name,
            s.class,
            s.academic_year,
            s.user_id,
            u.username,
            p.full_name as parent_name,
            p.mobile_phone as parent_phone
        FROM students s
        JOIN student_users u ON s.user_id = u.id
        LEFT JOIN parents p ON s.id = p.student_id
        WHERE s.first_name = ? AND s.last_name = ?
        ORDER BY s.id
    ");
    $stmt->execute(['Elisha', 'Ayakpagi']);
    $records = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "\nRecords for Elisha Awonseba Ayakpagi:\n";
    foreach ($records as $record) {
        echo "- ID: {$record['id']}, Class: {$record['class']}, Year: {$record['academic_year']}, Username: {$record['username']}, Parent: {$record['parent_name']}\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
