<?php
require_once '../config.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}

$user_id = $_SESSION['user_id'];
$user_role = $_SESSION['role'];

// Log the request
error_log("Request: " . $_SERVER['REQUEST_METHOD'] . " " . $_SERVER['REQUEST_URI'] . " by user " . $user_id . " at " . date('Y-m-d H:i:s'));

$leave_id = $_GET['id'] ?? 0;

if (!$leave_id) {
    echo json_encode(['success' => false, 'message' => 'Leave ID required']);
    exit;
}

try {
    // Check if user is admin or the leave belongs to them
    $is_admin = in_array($user_role, ['admin', 'super_admin']);
    $where_clause = $is_admin ? "WHERE sla.id = ?" : "WHERE sla.id = ? AND sla.user_id = ?";

    $params = $is_admin ? [$leave_id] : [$leave_id, $user_id];

    $stmt = $pdo->prepare("
        SELECT sla.*,
               u.username,
               CONCAT(s.first_name, ' ', s.last_name) as staff_name,
               s.staff_id,
               reviewer.username as reviewer_name
        FROM staff_leave_applications sla
        LEFT JOIN users u ON sla.user_id = u.id
        LEFT JOIN (
            SELECT id as staff_id, user_id, first_name, last_name FROM teachers
            UNION ALL
            SELECT id as staff_id, user_id, first_name, last_name FROM librarians
            UNION ALL
            SELECT id as staff_id, user_id, first_name, last_name FROM non_teaching
            UNION ALL
            SELECT id as staff_id, user_id, first_name, last_name FROM directors
            UNION ALL
            SELECT id as staff_id, user_id, first_name, last_name FROM head_teachers
        ) s ON sla.user_id = s.user_id
        LEFT JOIN users reviewer ON sla.reviewed_by = reviewer.id
        $where_clause
    ");

    $stmt->execute($params);
    $leave = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($leave) {
        echo json_encode([
            'success' => true,
            'leave' => $leave
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Leave application not found']);
    }

} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
