<?php
require_once '../config.php';
require_once '../includes/access_control.php';

$message = '';

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        if (isset($_POST['add_class'])) {
            $name = trim($_POST['name']);
            $description = trim($_POST['description']);
            $level_id = $_POST['level_id'] ?? null;

            $stmt = $pdo->prepare("INSERT INTO classes (name, description, level_id) VALUES (?, ?, ?)");
            $stmt->execute([$name, $description, $level_id]);

            $_SESSION['message'] = 'Class added successfully.';
            header('Location: view_classes.php');
            exit();
        } elseif (isset($_POST['edit_class'])) {
            $class_id = $_POST['class_id'];
            $name = trim($_POST['name']);
            $description = trim($_POST['description']);
            $level_id = $_POST['level_id'] ?? null;

            $stmt = $pdo->prepare("UPDATE classes SET name = ?, description = ?, level_id = ? WHERE id = ?");
            $stmt->execute([$name, $description, $level_id, $class_id]);

            $_SESSION['message'] = 'Class updated successfully.';
            header('Location: view_classes.php');
            exit();
        } elseif (isset($_POST['delete_class'])) {
            $class_id = $_POST['class_id'];

            $stmt = $pdo->prepare("DELETE FROM classes WHERE id = ?");
            $stmt->execute([$class_id]);

            $_SESSION['message'] = 'Class deleted successfully.';
            header('Location: view_classes.php');
            exit();
        }
    } catch (PDOException $e) {
        $message = 'Error: ' . $e->getMessage();
    }
}

// Get all levels for dropdown
$levels = $pdo->query("SELECT * FROM levels ORDER BY name")->fetchAll();

// Get all classes
$stmt = $pdo->query("SELECT c.*, l.name as level_name FROM classes c LEFT JOIN levels l ON c.level_id = l.id ORDER BY c.name");
$classes = $stmt->fetchAll();

// Get class for edit
$edit_class = null;
if (isset($_GET['edit'])) {
    $class_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM classes WHERE id = ?");
    $stmt->execute([$class_id]);
    $edit_class = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<h2>Manage Classes</h2>

<?php if ($message && strpos($message, 'Error:') === 0): ?>
<script>
window.addEventListener('load', function() {
    $('#errorMessage').text('<?php echo addslashes($message); ?>');
    $('#errorModal').modal('show');
});
</script>
<?php elseif ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert" style="font-size: 18px; font-weight: bold;">
        <?php echo htmlspecialchars($message); ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<!-- Button to trigger add modal -->
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addClassModal">Add New Class</button>

<!-- Add/Edit Class Modal -->
<div class="modal fade" id="addClassModal" tabindex="-1" role="dialog" aria-labelledby="addClassModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addClassModalLabel"><?php echo $edit_class ? 'Edit Class' : 'Add New Class'; ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="view_classes.php" id="classForm">
                    <?php if ($edit_class): ?>
                        <input type="hidden" name="class_id" value="<?php echo $edit_class['id']; ?>">
                    <?php endif; ?>

                    <div class="form-group">
                        <label for="name">Class Name:</label>
                        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($edit_class['name'] ?? ''); ?>" required>
                    </div>

                    <div class="form-group">
                        <label for="description">Description:</label>
                        <textarea id="description" name="description"><?php echo htmlspecialchars($edit_class['description'] ?? ''); ?></textarea>
                    </div>
                    <div class="form-group" style="position: relative; z-index: 1050;">
                        <label for="level_id">Level:</label>
                        <select id="level_id" name="level_id" class="form-control" style="margin-bottom: 1rem;">
                            <option value="">Select Level</option>
                            <?php foreach ($levels as $level): ?>
                                <option value="<?php echo $level['id']; ?>" <?php echo (isset($edit_class['level_id']) && $edit_class['level_id'] == $level['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($level['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" form="classForm" name="<?php echo $edit_class ? 'edit_class' : 'add_class'; ?>" class="btn btn-primary">
                    <?php echo $edit_class ? 'Update Class' : 'Add Class'; ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Error Modal -->
<div class="modal fade" id="errorModal" tabindex="-1" role="dialog" aria-labelledby="errorModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="errorModalLabel">Error</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="errorMessage"></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<?php if ($edit_class): ?>
<script>
window.addEventListener('load', function() {
    $('#addClassModal').modal('show');
});
</script>
<?php endif; ?>

<h3>All Classes</h3>

<?php if (empty($classes)): ?>
    <p>No classes found.</p>
<?php else: ?>
    <table class="fees-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Description</th>
                <th>Level</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($classes as $class): ?>
                <tr>
                    <td><?php echo htmlspecialchars($class['name']); ?></td>
                    <td><?php echo htmlspecialchars($class['description']); ?></td>
                    <td><?php echo htmlspecialchars($class['level_name'] ?? ''); ?></td>
                    <td><?php echo htmlspecialchars($class['created_at']); ?></td>
                    <td>
                        <a href="?edit=<?php echo $class['id']; ?>" class="btn btn-small">Edit</a>
                        <form method="post" action="view_classes.php" style="display:inline;">
                            <input type="hidden" name="class_id" value="<?php echo $class['id']; ?>">
                            <button type="submit" name="delete_class" class="btn btn-small btn-danger" onclick="return confirm('Are you sure you want to delete this class?')">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<style>
.fees-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.fees-table table {
    width: 100%;
    border-collapse: collapse;
}

.fees-table th,
.fees-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.fees-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.fees-table tr:hover {
    background: #f8f9fa;
}
</style>

<?php
include '../includes/admin_footer.php';
?>
