<?php
require_once '../config.php';
require_once '../auto_enroll_students.php';

$message = '';
$errors = [];

try {
    // Fetch distinct classes and academic years for dropdowns
    $classes_stmt = $pdo->query("SELECT DISTINCT name FROM classes ORDER BY name");
    $classes = $classes_stmt->fetchAll(PDO::FETCH_COLUMN);

    $years_stmt = $pdo->query("SELECT DISTINCT year FROM academic_years ORDER BY year");
    $academic_years = $years_stmt->fetchAll(PDO::FETCH_COLUMN);

    $students = [];
    $selected_current_class = $_POST['current_class'] ?? '';
    $selected_current_year = $_POST['current_academic_year'] ?? '';
    $selected_target_class = $_POST['target_class'] ?? '';
    $selected_target_year = $_POST['target_academic_year'] ?? '';

    // Fetch students for selected current class and academic year
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['fetch_students'])) {
        if ($selected_current_class && $selected_current_year) {
            $stmt = $pdo->prepare("SELECT * FROM students WHERE class = ? AND academic_year = ? ORDER BY name");
            $stmt->execute([$selected_current_class, $selected_current_year]);
            $students = $stmt->fetchAll();
        } else {
            $errors[] = "Please select current class and academic year to fetch students.";
        }
    }

    // Handle promotion form submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['promote_students'])) {
        $promote_student_ids = $_POST['promote_student_ids'] ?? [];
        $selected_target_class = $_POST['target_class'] ?? '';
        $selected_target_year = $_POST['target_academic_year'] ?? '';

        if (empty($promote_student_ids)) {
            $errors[] = "No students selected for promotion.";
        }
        if (!$selected_target_class || !$selected_target_year) {
            $errors[] = "Please select target class and academic year.";
        }

        if (empty($errors)) {
            $pdo->beginTransaction();
            try {
                $update_stmt = $pdo->prepare("UPDATE students SET class = ?, academic_year = ? WHERE id = ?");
                foreach ($promote_student_ids as $student_id) {
                    $update_stmt->execute([$selected_target_class, $selected_target_year, $student_id]);
                }
                $pdo->commit();

                // Auto-enroll promoted students in new class courses for the target academic year
                $auto_enroll_result = autoEnrollClass($selected_target_class);

                $message = "Promotion successful. " . count($promote_student_ids) . " students promoted.";
                if ($auto_enroll_result['success']) {
                    $message .= " " . $auto_enroll_result['message'];
                } else {
                    $message .= " Auto-enrollment failed: " . $auto_enroll_result['message'];
                }
                // Clear students list after promotion
                $students = [];
            } catch (Exception $e) {
                $pdo->rollBack();
                $errors[] = "Promotion failed: " . $e->getMessage();
            }
        }
    }
} catch (Exception $e) {
    $errors[] = "Error: " . $e->getMessage();
}

include '../includes/admin_header.php';
?>

<h2>Promote Students to Next Level</h2>

<?php if ($message): ?>
    <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <ul>
            <?php foreach ($errors as $error): ?>
                <li><?php echo htmlspecialchars($error); ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<form method="post" action="promote_students.php" class="form-inline">
    <div class="form-group">
        <label for="current_class">Current Class:</label>
        <select id="current_class" name="current_class" required>
            <option value="">-- Select Class --</option>
            <?php foreach ($classes as $class): ?>
                <option value="<?php echo htmlspecialchars($class); ?>" <?php if ($class == $selected_current_class) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($class); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <div class="form-group">
        <label for="current_academic_year">Current Academic Year:</label>
        <select id="current_academic_year" name="current_academic_year" required>
            <option value="">-- Select Academic Year --</option>
            <?php foreach ($academic_years as $year): ?>
                <option value="<?php echo htmlspecialchars($year); ?>" <?php if ($year == $selected_current_year) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($year); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>

    <button type="submit" name="fetch_students" class="btn btn-primary">Fetch Students</button>
</form>

<?php if (!empty($students)): ?>
    <form method="post" action="promote_students.php">
        <input type="hidden" name="current_class" value="<?php echo htmlspecialchars($selected_current_class); ?>">
        <input type="hidden" name="current_academic_year" value="<?php echo htmlspecialchars($selected_current_year); ?>">

        <h3>Students in <?php echo htmlspecialchars($selected_current_class); ?> (<?php echo htmlspecialchars($selected_current_year); ?>)</h3>

        <table class="table table-striped">
            <thead>
                <tr>
                    <th><input type="checkbox" id="select_all" onclick="toggleSelectAll(this)"></th>
                    <th>Name</th>
                    <th>Class</th>
                    <th>Academic Year</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($students as $student): ?>
                    <tr>
                        <td><input type="checkbox" name="promote_student_ids[]" value="<?php echo $student['id']; ?>"></td>
                        <td><?php echo htmlspecialchars($student['name']); ?></td>
                        <td><?php echo htmlspecialchars($student['class']); ?></td>
                        <td><?php echo htmlspecialchars($student['academic_year']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="form-group">
            <label for="target_class">Promote To Class:</label>
            <select id="target_class" name="target_class" required>
                <option value="">-- Select Class --</option>
                <?php foreach ($classes as $class): ?>
                    <option value="<?php echo htmlspecialchars($class); ?>" <?php if ($class == $selected_target_class) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($class); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group">
            <label for="target_academic_year">Promote To Academic Year:</label>
            <select id="target_academic_year" name="target_academic_year" required>
                <option value="">-- Select Academic Year --</option>
                <?php foreach ($academic_years as $year): ?>
                    <option value="<?php echo htmlspecialchars($year); ?>" <?php if ($year == $selected_target_year) echo 'selected'; ?>>
                        <?php echo htmlspecialchars($year); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit" name="promote_students" class="btn btn-success">Promote Selected Students</button>
    </form>
<?php endif; ?>

<script>
function toggleSelectAll(source) {
    checkboxes = document.getElementsByName('promote_student_ids[]');
    for(var i=0, n=checkboxes.length;i<n;i++) {
        checkboxes[i].checked = source.checked;
    }
}
</script>

<?php
include '../includes/admin_footer.php';
?>
