<?php
require_once '../config.php';
require_once '../includes/access_control.php';

$message = '';

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['edit_student'])) {
        $student_id = $_POST['edit_student_id'];
        $first_name = trim($_POST['first_name']);
        $middle_name = trim($_POST['middle_name']);
        $last_name = trim($_POST['last_name']);
        $class = trim($_POST['class']);
        $academic_year = trim($_POST['academic_year']);
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $place_of_birth_city = trim($_POST['place_of_birth_city']);
        $place_of_birth_country = trim($_POST['place_of_birth_country']);
        $nationality = trim($_POST['nationality']);
        $religion = trim($_POST['religion']);
        $home_street = trim($_POST['home_street']);
        $home_city = trim($_POST['home_city']);
        $home_state = trim($_POST['home_state']);
        $home_postal = trim($_POST['home_postal']);
        $home_country = trim($_POST['home_country']);
        $student_id_field = trim($_POST['student_id']);
        $term_admission = trim($_POST['term_admission']);
        $languages_home = trim($_POST['languages_home']);
        $phone = trim($_POST['phone']);
        $previous_school_name = trim($_POST['previous_school_name']);
        $previous_school_address = trim($_POST['previous_school_address']);

        // Handle photo upload
        $photo_path = null;
        if (isset($_FILES['photo']) && $_FILES['photo']['error'] == 0) {
            $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
            $file_type = $_FILES['photo']['type'];
            $file_size = $_FILES['photo']['size'];

            if (in_array($file_type, $allowed_types) && $file_size <= 5 * 1024 * 1024) { // 5MB limit
                $upload_dir = '../uploads/students/';
                $file_extension = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
                $new_filename = 'student_' . $student_id . '_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;

                if (move_uploaded_file($_FILES['photo']['tmp_name'], $upload_path)) {
                    $photo_path = 'uploads/students/' . $new_filename;
                }
            }
        }

        // Build update query with all fields
        $update_fields = [
            'first_name' => $first_name,
            'middle_name' => $middle_name,
            'last_name' => $last_name,
            'class' => $class,
            'academic_year' => $academic_year,
            'dob' => $dob,
            'gender' => $gender,
            'place_of_birth_city' => $place_of_birth_city,
            'place_of_birth_country' => $place_of_birth_country,
            'nationality' => $nationality,
            'religion' => $religion,
            'home_street' => $home_street,
            'home_city' => $home_city,
            'home_state' => $home_state,
            'home_postal' => $home_postal,
            'home_country' => $home_country,
            'student_id' => $student_id_field,
            'term_admission' => $term_admission,
            'languages_home' => $languages_home,
            'phone' => $phone,
            'previous_school_name' => $previous_school_name,
            'previous_school_address' => $previous_school_address
        ];

        if ($photo_path !== null) {
            $update_fields['photo_path'] = $photo_path;
        }

        // Build the SET clause dynamically
        $set_clause = '';
        $params = [];
        foreach ($update_fields as $field => $value) {
            $set_clause .= "$field = ?, ";
            $params[] = $value;
        }
        $set_clause = rtrim($set_clause, ', ');
        $params[] = $student_id;

        $stmt = $pdo->prepare("UPDATE students SET $set_clause WHERE id = ?");
        $stmt->execute($params);

        // Auto-enroll student in all courses for their new class if class was changed
        if ($class !== $edit_student['class']) {
            require_once '../auto_enroll_students.php';
            $enrollment_result = autoEnrollStudent($student_id, $class);
            if ($enrollment_result['success']) {
                $_SESSION['message'] = 'Student updated successfully. ' . $enrollment_result['message'];
            } else {
                $_SESSION['message'] = 'Student updated successfully, but auto-enrollment failed: ' . $enrollment_result['message'];
            }
        } else {
            $_SESSION['message'] = 'Student updated successfully.';
        }
        header('Location: manage_students.php');
        exit();
    } elseif (isset($_POST['delete_student'])) {
        $student_id = $_POST['student_id'];

        // Delete student (cascade will delete user)
        $stmt = $pdo->prepare("DELETE FROM students WHERE id = ?");
        $stmt->execute([$student_id]);

        $_SESSION['message'] = 'Student deleted successfully.';
        header('Location: manage_students.php');
        exit();
    }
}

// Get filter values
$filter_class = $_GET['class'] ?? '';
$filter_academic_year = $_GET['academic_year'] ?? '';
$search_term = $_GET['search'] ?? '';
$page = $_GET['page'] ?? 1;
$per_page = 10;

// Get total count for pagination
$total_query = "SELECT COUNT(*) FROM students s JOIN student_users su ON s.user_id = su.id WHERE 1=1";
$total_params = [];

if ($filter_class) {
    $total_query .= " AND s.class = ?";
    $total_params[] = $filter_class;
}
if ($filter_academic_year) {
    $total_query .= " AND s.academic_year = ?";
    $total_params[] = $filter_academic_year;
}

if ($search_term) {
    $total_query .= " AND (su.username LIKE ? OR s.first_name LIKE ? OR s.middle_name LIKE ? OR s.last_name LIKE ?)";
    $search_like = '%' . $search_term . '%';
    $total_params[] = $search_like;
    $total_params[] = $search_like;
    $total_params[] = $search_like;
    $total_params[] = $search_like;
}

$total_stmt = $pdo->prepare($total_query);
$total_stmt->execute($total_params);
$total_students = $total_stmt->fetchColumn();
$total_pages = ceil($total_students / $per_page);

// Get students with optional filters and pagination
$query = "SELECT s.*, su.username FROM students s JOIN student_users su ON s.user_id = su.id WHERE 1=1";
$params = [];

if ($filter_class) {
    $query .= " AND s.class = ?";
    $params[] = $filter_class;
}
if ($filter_academic_year) {
    $query .= " AND s.academic_year = ?";
    $params[] = $filter_academic_year;
}
if ($search_term) {
    $query .= " AND (su.username LIKE ? OR s.first_name LIKE ? OR s.middle_name LIKE ? OR s.last_name LIKE ?)";
    $search_like = '%' . $search_term . '%';
    $params[] = $search_like;
    $params[] = $search_like;
    $params[] = $search_like;
    $params[] = $search_like;
}

$query .= " ORDER BY s.last_name ASC, s.first_name ASC LIMIT $per_page OFFSET " . (($page - 1) * $per_page);

$stmt = $pdo->prepare($query);
$stmt->execute($params);
$students = $stmt->fetchAll();

// Get distinct classes and academic years for filter dropdowns
$classes_stmt = $pdo->query("SELECT DISTINCT class FROM students ORDER BY class");
$classes = $classes_stmt->fetchAll(PDO::FETCH_COLUMN);

$years_stmt = $pdo->query("SELECT DISTINCT academic_year FROM students ORDER BY academic_year");
$academic_years = $years_stmt->fetchAll(PDO::FETCH_COLUMN);

// Get student for edit
$edit_student = null;
if (isset($_GET['edit'])) {
    $student_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT s.*, su.username FROM students s JOIN student_users su ON s.user_id = su.id WHERE s.id = ?");
    $stmt->execute([$student_id]);
    $edit_student = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<div class="header-container">
    <h2>Manage Students</h2>
    <div class="search-container">
        <form method="get" action="manage_students.php" style="display: inline;">
            <input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search_term); ?>" placeholder="Enter student name..." style="padding: 10px; border: 1px solid #ced4da; border-radius: 4px; font-size: 14px; width: 250px;">
            <button type="submit" class="btn btn-primary" style="margin-left: 10px;">Search</button>
        </form>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert" style="font-size: 18px; font-weight: bold;">
        <?php echo htmlspecialchars($message); ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<!-- Removed the add/edit student form as per user request -->
<!-- Form removed -->


<div class="filter-container">
    <h3>Filter Students</h3>
    <form method="get" action="manage_students.php" class="filter-form">
        <div class="filter-row">
            <div class="filter-group">
                <label for="class">Filter by Class:</label>
                <select id="class" name="class">
                    <option value="">All</option>
                    <?php foreach ($classes as $class): ?>
                        <option value="<?php echo htmlspecialchars($class); ?>" <?php if ($class == $filter_class) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($class); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="filter-group">
                <label for="academic_year">Filter by Academic Year:</label>
                <select id="academic_year" name="academic_year">
                    <option value="">All</option>
                    <?php foreach ($academic_years as $year): ?>
                        <option value="<?php echo htmlspecialchars($year); ?>" <?php if ($year == $filter_academic_year) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($year); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="filter-actions">
            <button type="submit" class="btn btn-primary">Apply Filter</button>
            <a href="manage_students.php" class="btn btn-secondary">Clear Filters</a>
        </div>
    </form>
</div>

<!-- Modal for editing student -->
<div id="editStudentModal" class="modal" style="<?php echo $edit_student ? 'display:block;' : 'display:none;'; ?>">
    <div class="modal-content">
        <span class="close" onclick="closeModal()">&times;</span>
        <h3>Edit Student</h3>

        <form method="post" action="manage_students.php" enctype="multipart/form-data">
            <input type="hidden" name="edit_student_id" value="<?php echo $edit_student['id'] ?? ''; ?>">

            <div class="form-row">
                <div class="form-group">
                    <label for="first_name">First Name:</label>
                    <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($edit_student['first_name'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label for="middle_name">Middle Name:</label>
                    <input type="text" id="middle_name" name="middle_name" value="<?php echo htmlspecialchars($edit_student['middle_name'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="last_name">Last Name:</label>
                    <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($edit_student['last_name'] ?? ''); ?>" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="class">Class:</label>
                    <input type="text" id="class" name="class" value="<?php echo htmlspecialchars($edit_student['class'] ?? ''); ?>" required>
                </div>

                <div class="form-group">
                    <label for="academic_year">Academic Year:</label>
                    <input type="text" id="academic_year" name="academic_year" value="<?php echo htmlspecialchars($edit_student['academic_year'] ?? ''); ?>" required>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="dob">Date of Birth:</label>
                    <input type="date" id="dob" name="dob" value="<?php echo htmlspecialchars($edit_student['dob'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="gender">Gender:</label>
                    <select id="gender" name="gender">
                        <option value="">Select Gender</option>
                        <option value="Male" <?php echo ($edit_student['gender'] ?? '') == 'Male' ? 'selected' : ''; ?>>Male</option>
                        <option value="Female" <?php echo ($edit_student['gender'] ?? '') == 'Female' ? 'selected' : ''; ?>>Female</option>
                        <option value="Other" <?php echo ($edit_student['gender'] ?? '') == 'Other' ? 'selected' : ''; ?>>Other</option>
                    </select>
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="place_of_birth_city">Place of Birth (City):</label>
                    <input type="text" id="place_of_birth_city" name="place_of_birth_city" value="<?php echo htmlspecialchars($edit_student['place_of_birth_city'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="place_of_birth_country">Place of Birth (Country):</label>
                    <input type="text" id="place_of_birth_country" name="place_of_birth_country" value="<?php echo htmlspecialchars($edit_student['place_of_birth_country'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="nationality">Nationality:</label>
                    <input type="text" id="nationality" name="nationality" value="<?php echo htmlspecialchars($edit_student['nationality'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="religion">Religion:</label>
                    <input type="text" id="religion" name="religion" value="<?php echo htmlspecialchars($edit_student['religion'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="home_street">Home Street:</label>
                    <input type="text" id="home_street" name="home_street" value="<?php echo htmlspecialchars($edit_student['home_street'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="home_city">Home City:</label>
                    <input type="text" id="home_city" name="home_city" value="<?php echo htmlspecialchars($edit_student['home_city'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="home_state">Home State:</label>
                    <input type="text" id="home_state" name="home_state" value="<?php echo htmlspecialchars($edit_student['home_state'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="home_postal">Home Postal:</label>
                    <input type="text" id="home_postal" name="home_postal" value="<?php echo htmlspecialchars($edit_student['home_postal'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="home_country">Home Country:</label>
                    <input type="text" id="home_country" name="home_country" value="<?php echo htmlspecialchars($edit_student['home_country'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="student_id">Student ID:</label>
                    <input type="text" id="student_id" name="student_id" value="<?php echo htmlspecialchars($edit_student['student_id'] ?? ''); ?>" readonly>
                </div>

                <div class="form-group">
                    <label for="term_admission">Term Admission:</label>
                    <input type="text" id="term_admission" name="term_admission" value="<?php echo htmlspecialchars($edit_student['term_admission'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group">
                    <label for="languages_home">Languages Home:</label>
                    <input type="text" id="languages_home" name="languages_home" value="<?php echo htmlspecialchars($edit_student['languages_home'] ?? ''); ?>">
                </div>

                <div class="form-group">
                    <label for="phone">Phone:</label>
                    <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($edit_student['phone'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group full-width">
                    <label for="previous_school_name">Previous School Name:</label>
                    <input type="text" id="previous_school_name" name="previous_school_name" value="<?php echo htmlspecialchars($edit_student['previous_school_name'] ?? ''); ?>">
                </div>
            </div>

            <div class="form-row">
                <div class="form-group full-width">
                    <label for="previous_school_address">Previous School Address:</label>
                    <textarea id="previous_school_address" name="previous_school_address"><?php echo htmlspecialchars($edit_student['previous_school_address'] ?? ''); ?></textarea>
                </div>
            </div>

            <div class="form-group">
                <label for="photo">Update Photo:</label>
                <input type="file" id="photo" name="photo" accept="image/*">
                <?php if (!empty($edit_student['photo_path'])): ?>
                    <p><small>Current photo: <img src="../<?php echo htmlspecialchars($edit_student['photo_path']); ?>" alt="Current photo" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;"></small></p>
                <?php endif; ?>
            </div>

            <button type="submit" name="edit_student" class="btn btn-primary">Update Student</button>
            <button type="button" class="btn" onclick="closeModal()">Cancel</button>
        </form>
    </div>
</div>

<?php if ($filter_class || $filter_academic_year || $search_term): ?>
<div class="table-header">
    <h3>Students List</h3>
    <?php if ($filter_class): ?>
        <a href="print_students.php?class=<?php echo urlencode($filter_class); ?>" class="btn btn-primary" target="_blank">Print Students</a>
    <?php endif; ?>
</div>
<table class="fees-table">
    <thead>
        <tr>
            <th>Student ID</th>
            <th>Name</th>
            <th>Class</th>
            <th>Gender</th>
            <th>Nationality</th>
            <th>Emergency Contact</th>
            <th>Phone</th>
            <th>Photo</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($students as $student): ?>
            <tr>
                <td><?php echo htmlspecialchars($student['student_id'] ?? $student['id']); ?></td>
                <td><?php echo htmlspecialchars(trim(($student['last_name'] ?? '') . ' ' . ($student['middle_name'] ?? '') . ' ' . ($student['first_name'] ?? ''))); ?></td>
                <td><?php echo htmlspecialchars($student['class']); ?></td>
                <td><?php echo htmlspecialchars($student['gender'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($student['nationality'] ?? ''); ?></td>
                <td>
                    <?php
                    $emergency = '';
                    if (!empty($student['emergency_contact_name'])) {
                        $emergency = htmlspecialchars($student['emergency_contact_name']);
                        if (!empty($student['emergency_contact_phone'])) {
                            $emergency .= '<br><small>' . htmlspecialchars($student['emergency_contact_phone']) . '</small>';
                        }
                    }
                    echo $emergency;
                    ?>
                </td>
                <td><?php echo htmlspecialchars($student['phone']); ?></td>
                <td>
                    <?php if (!empty($student['photo_path'])): ?>
                        <img src="../<?php echo htmlspecialchars($student['photo_path']); ?>" alt="Photo" style="width: 40px; height: 40px; object-fit: cover; border-radius: 50%;">
                    <?php else: ?>
                        <span style="color: #999;">No photo</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="?edit=<?php echo $student['id']; ?>" class="btn btn-small">Edit</a>
                    <form method="post" action="manage_students.php" style="display:inline;">
                        <input type="hidden" name="student_id" value="<?php echo $student['id']; ?>">
                        <button type="submit" name="delete_student" class="btn btn-small btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<!-- Pagination -->
<?php if ($total_pages > 1): ?>
<div class="pagination">
    <?php if ($page > 1): ?>
        <a href="?page=<?php echo $page - 1; ?>&class=<?php echo urlencode($filter_class); ?>&academic_year=<?php echo urlencode($filter_academic_year); ?>&search=<?php echo urlencode($search_term); ?>" class="btn btn-small">Previous</a>
    <?php endif; ?>

    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
        <a href="?page=<?php echo $i; ?>&class=<?php echo urlencode($filter_class); ?>&academic_year=<?php echo urlencode($filter_academic_year); ?>&search=<?php echo urlencode($search_term); ?>" class="btn btn-small <?php echo $i == $page ? 'btn-primary' : ''; ?>"><?php echo $i; ?></a>
    <?php endfor; ?>

    <?php if ($page < $total_pages): ?>
        <a href="?page=<?php echo $page + 1; ?>&class=<?php echo urlencode($filter_class); ?>&academic_year=<?php echo urlencode($filter_academic_year); ?>&search=<?php echo urlencode($search_term); ?>" class="btn btn-small">Next</a>
    <?php endif; ?>
</div>
<?php endif; ?>

<?php else: ?>
<div class="info-message">
    <div class="info-icon">ℹ️</div>
    <div class="info-text">
        <h4>Please Apply a Filter</h4>
        <p>To view the list of students, please select a class or academic year from the filter options above.</p>
    </div>
</div>
<?php endif; ?>

<style>
.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 20px;
}

.form-row .form-group {
    flex: 1;
    margin-bottom: 0;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: #495057;
}

.form-group input[type="text"],
.form-group input[type="email"],
.form-group input[type="date"],
.form-group input[type="file"],
.form-group textarea,
.form-group select {
    width: 100%;
    padding: 10px;
    border: 1px solid #ced4da;
    border-radius: 4px;
    font-size: 14px;
}

.form-group textarea {
    resize: vertical;
    min-height: 80px;
}

.fees-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.fees-table table {
    width: 100%;
    border-collapse: collapse;
}

.fees-table th,
.fees-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.fees-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.fees-table tr:hover {
    background: #f8f9fa;
}

/* Modal styles */
.modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    overflow: auto;
    background-color: rgba(0,0,0,0.4);
}

.modal-content {
    background-color: #fefefe;
    margin: 5% auto;
    padding: 20px;
    border: 1px solid #888;
    width: 80%;
    max-width: 600px;
    border-radius: 8px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}

.close {
    color: #aaa;
    float: right;
    font-size: 28px;
    font-weight: bold;
    cursor: pointer;
}

.close:hover,
.close:focus {
    color: black;
    text-decoration: none;
}

/* Pagination styles */
.pagination {
    display: flex;
    justify-content: center;
    margin-top: 20px;
    gap: 5px;
}

.pagination a {
    padding: 8px 12px;
    text-decoration: none;
    border: 1px solid #ddd;
    color: #007bff;
    border-radius: 4px;
}

.pagination a:hover {
    background-color: #f8f9fa;
}

.pagination a.btn-primary {
    background-color: #122a42ff;
    color: white;
    border-color: #0d1f31ff;
}

/* Filter container styles */
.filter-container {
    background: white;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.filter-container h3 {
    margin-top: 0;
    margin-bottom: 20px;
    color: #495057;
    font-size: 18px;
    font-weight: 600;
}

.filter-form {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.filter-row {
    display: flex;
    gap: 20px;
    flex-wrap: wrap;
}

.filter-group {
    flex: 1;
    min-width: 200px;
}

.filter-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: 600;
    color: #495057;
}

.filter-group select {
    width: 100%;
    padding: 10px;
    border: 1px solid #ced4da;
    border-radius: 4px;
    font-size: 14px;
}

.filter-actions {
    display: flex;
    gap: 10px;
    justify-content: flex-start;
}

.filter-actions .btn {
    padding: 10px 20px;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
    text-decoration: none;
    display: inline-block;
}

.filter-actions .btn-primary {
    background-color: #28a745;
    color: white;
}

.filter-actions .btn-primary:hover {
    background-color: #218838;
}

.filter-actions .btn-secondary {
    background-color: #6c757d;
    color: white;
}

.filter-actions .btn-secondary:hover {
    background-color: #545b62;
}

/* Info message styles */
.info-message {
    background: #e7f3ff;
    border: 1px solid #b3d9ff;
    border-radius: 8px;
    padding: 20px;
    display: flex;
    align-items: center;
    gap: 15px;
    margin-top: 20px;
}

.info-icon {
    font-size: 24px;
    color: #007bff;
}

.info-text h4 {
    margin: 0 0 5px 0;
    color: #007bff;
    font-size: 16px;
    font-weight: 600;
}

.info-text p {
    margin: 0;
    color: #495057;
    font-size: 14px;
}

/* Table header styles */
.table-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.table-header h3 {
    margin: 0;
    color: #495057;
    font-size: 1.5em;
    font-weight: 600;
}
</style>

<script>
function closeModal() {
    document.getElementById('editStudentModal').style.display = 'none';
    window.location.href = 'manage_students.php';
}

// Close modal when clicking outside
window.onclick = function(event) {
    var modal = document.getElementById('editStudentModal');
    if (event.target == modal) {
        closeModal();
    }
}
</script>

<?php
include '../includes/admin_footer.php';
?>
