<?php
require_once '../config.php';
require_once '../includes/access_control.php';
require_once '../includes/password_security.php';

// requireFeatureAccess('staff_management');

$message = '';

if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_staff'])) {
        $username = trim($_POST['username']);
        // Use secure password hashing with proper validation
        $password_errors = PasswordSecurity::validatePasswordStrength($_POST['password']);
        if (!empty($password_errors)) {
            $_SESSION['message'] = implode(' ', $password_errors);
            header('Location: manage_staff.php');
            exit();
        }

        // Check if passwords match
        if ($_POST['password'] !== $_POST['confirm_password']) {
            $_SESSION['message'] = 'Passwords do not match.';
            header('Location: manage_staff.php');
            exit();
        }
        $password = PasswordSecurity::hashPassword($_POST['password']);
        $role = $_POST['role'];
        $first_name = trim($_POST['first_name']);
        $middle_name = trim($_POST['middle_name']);
        $last_name = trim($_POST['last_name']);
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $address = trim($_POST['address']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $ghana_card_number = trim($_POST['ghana_card_number']);
        $qualification = trim($_POST['qualification']);
        $job_position = trim($_POST['job_position']);
        $staff_rank = trim($_POST['staff_rank']);
        $department = trim($_POST['department']);
        $hire_date = $_POST['hire_date'];

        // Handle profile image upload
        $profile_image_path = null;
        if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] == UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/staff/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $file_name = uniqid() . '_' . basename($_FILES['profile_image']['name']);
            $target_file = $upload_dir . $file_name;
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            // Validate image
            $check = getimagesize($_FILES['profile_image']['tmp_name']);
            if ($check !== false && in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif']) && $_FILES['profile_image']['size'] < 5000000) {
                if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $target_file)) {
                    $profile_image_path = 'uploads/staff/' . $file_name;
                } else {
                    $_SESSION['message'] = 'Failed to upload profile image.';
                    header('Location: manage_staff.php');
                    exit();
                }
            } else {
                $_SESSION['message'] = 'Invalid profile image file. Must be JPG, JPEG, PNG, GIF and less than 5MB.';
                header('Location: manage_staff.php');
                exit();
            }
        }

        // Insert user into staff_accounts table
        $stmt = $pdo->prepare("INSERT INTO staff_accounts (username, password, first_name, last_name, created_at) VALUES (?, ?, ?, ?, NOW())");
        $stmt->execute([$username, $password, $first_name, $last_name]);
        $user_id = $pdo->lastInsertId();

        // Insert staff
        $stmt = $pdo->prepare("INSERT INTO staff (user_id, username, password, role, first_name, middle_name, last_name, dob, gender, address, email, phone, ghana_card_number, qualification, job_position, staff_rank, department, hire_date, profile_image) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$user_id, $username, $password, $role, $first_name, $middle_name, $last_name, $dob, $gender, $address, $email, $phone, $ghana_card_number, $qualification, $job_position, $staff_rank, $department, $hire_date, $profile_image_path]);

        // Generate and set staff_id
        $staff_table_id = $pdo->lastInsertId();
        $staff_id = generate_staff_id($pdo, $role);
        $stmt = $pdo->prepare("UPDATE staff SET staff_id = ? WHERE id = ?");
        $stmt->execute([$staff_id, $staff_table_id]);

        $_SESSION['message'] = 'Staff added successfully.';
        header('Location: manage_staff.php');
        exit();
    } elseif (isset($_POST['edit_staff'])) {
        $staff_id = $_POST['staff_id'];
        $role = $_POST['role'];
        $first_name = trim($_POST['first_name']);
        $middle_name = trim($_POST['middle_name']);
        $last_name = trim($_POST['last_name']);
        $dob = $_POST['dob'];
        $gender = $_POST['gender'];
        $address = trim($_POST['address']);
        $email = trim($_POST['email']);
        $phone = trim($_POST['phone']);
        $ghana_card_number = trim($_POST['ghana_card_number']);
        $qualification = trim($_POST['qualification']);
        $job_position = trim($_POST['job_position']);
        $staff_rank = trim($_POST['staff_rank']);
        $department = trim($_POST['department']);
        $hire_date = $_POST['hire_date'];

        // Handle profile image upload
        $profile_image_path = trim($_POST['profile_image']); // Keep existing if no new upload
        if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] == UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/staff/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            $file_name = uniqid() . '_' . basename($_FILES['profile_image']['name']);
            $target_file = $upload_dir . $file_name;
            $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));

            // Validate image
            $check = getimagesize($_FILES['profile_image']['tmp_name']);
            if ($check !== false && in_array($imageFileType, ['jpg', 'jpeg', 'png', 'gif']) && $_FILES['profile_image']['size'] < 5000000) {
                if (move_uploaded_file($_FILES['profile_image']['tmp_name'], $target_file)) {
                    $profile_image_path = 'uploads/staff/' . $file_name;
                } else {
                    $_SESSION['message'] = 'Failed to upload profile image.';
                    header('Location: manage_staff.php');
                    exit();
                }
            } else {
                $_SESSION['message'] = 'Invalid profile image file. Must be JPG, JPEG, PNG, GIF and less than 5MB.';
                header('Location: manage_staff.php');
                exit();
            }
        }

        // Handle password update if provided
        $update_fields = "role = ?, first_name = ?, middle_name = ?, last_name = ?, dob = ?, gender = ?, address = ?, email = ?, phone = ?, ghana_card_number = ?, qualification = ?, job_position = ?, staff_rank = ?, department = ?, hire_date = ?, profile_image = ?";
        $params = [$role, $first_name, $middle_name, $last_name, $dob, $gender, $address, $email, $phone, $ghana_card_number, $qualification, $job_position, $staff_rank, $department, $hire_date, $profile_image_path];

        if (!empty($_POST['password'])) {
            // Use secure password hashing with proper validation
            $password_errors = PasswordSecurity::validatePasswordStrength($_POST['password']);
            if (!empty($password_errors)) {
                $_SESSION['message'] = implode(' ', $password_errors);
                header('Location: manage_staff.php');
                exit();
            }
            $hashed_password = PasswordSecurity::hashPassword($_POST['password']);
            $update_fields .= ", password = ?";
            $params[] = $hashed_password;

            // Also update password in staff_accounts table
            $stmt_user = $pdo->prepare("UPDATE staff_accounts SET password = ? WHERE id = (SELECT user_id FROM staff WHERE id = ?)");
            $stmt_user->execute([$hashed_password, $staff_id]);
        }

        $params[] = $staff_id;
        $stmt = $pdo->prepare("UPDATE staff SET $update_fields WHERE id = ?");
        $stmt->execute($params);

        $_SESSION['message'] = 'Staff updated successfully.';
        header('Location: manage_staff.php');
        exit();
    } elseif (isset($_POST['delete_staff'])) {
        $staff_id = $_POST['staff_id'];

        // Delete staff (cascade will delete user)
        $stmt = $pdo->prepare("DELETE FROM staff WHERE id = ?");
        $stmt->execute([$staff_id]);

        $_SESSION['message'] = 'Staff deleted successfully.';
        header('Location: manage_staff.php');
        exit();
    }
}

function generate_staff_id($pdo, $role) {
    // Get school short name
    $stmt = $pdo->query("SELECT short_name FROM school_settings LIMIT 1");
    $school_settings = $stmt->fetch(PDO::FETCH_ASSOC);
    $short_name = $school_settings['short_name'] ?? 'SCHOOL';

    $prefix = '';
    switch ($role) {
        case 'teaching':
            $prefix = 'T';
            break;
        case 'non-teaching':
            $prefix = 'NT';
            break;
        case 'accountant':
            $prefix = 'A';
            break;
        case 'head_teacher':
            $prefix = 'HT';
            break;
        case 'director':
            $prefix = 'DIR';
            break;
        default:
            $prefix = 'S';
    }

    // Get the max id for this role with the new format (short_name-prefixXXX)
    $pattern = $short_name . '-' . $prefix . '%';
    $stmt = $pdo->prepare("SELECT MAX(CAST(SUBSTRING(staff_id, LENGTH(?) + 1) AS UNSIGNED)) as max_id FROM staff WHERE role = ? AND staff_id LIKE ?");
    $stmt->execute([$short_name . '-' . $prefix, $role, $pattern]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $max_id = $result['max_id'] ?? 0;
    $new_id = $max_id + 1;
    return $short_name . '-' . $prefix . str_pad($new_id, 3, '0', STR_PAD_LEFT);
}

// Get all levels for department dropdown
$levels = $pdo->query("SELECT * FROM levels ORDER BY name")->fetchAll();

$department_filter = isset($_GET['department']) ? trim($_GET['department']) : '';
$search_filter = isset($_GET['search']) ? trim($_GET['search']) : '';

// Get all staff accounts joined with staff table with optional filters across all tabs
$query = "SELECT sa.*, st.role, st.first_name, st.middle_name, st.last_name, st.job_position, st.gender, st.staff_rank, st.phone, st.email, st.profile_image, st.staff_id
          FROM staff_accounts sa
          JOIN staff st ON sa.id = st.user_id";

$params = [];
$conditions = [];

if (!empty($department_filter)) {
    $conditions[] = "st.department = ?";
    $params[] = $department_filter;
}

if (!empty($search_filter)) {
    // Change search to affect all staff, regardless of tab
    $conditions[] = "(sa.username LIKE ? OR st.first_name LIKE ? OR st.middle_name LIKE ? OR st.last_name LIKE ?)";
    $searchTerm = '%' . $search_filter . '%';
    $params[] = $searchTerm;
    $params[] = $searchTerm;
    $params[] = $searchTerm;
    $params[] = $searchTerm;
}

if (!empty($conditions)) {
    $query .= " WHERE " . implode(" AND ", $conditions);
}

$query .= " ORDER BY st.role, st.last_name";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$staff = $stmt->fetchAll();

// Get staff for edit
$edit_staff = null;
if (isset($_GET['edit'])) {
    $staff_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM staff WHERE id = ?");
    $stmt->execute([$staff_id]);
    $edit_staff = $stmt->fetch();
}

include '../includes/admin_header.php';

// Output staff data as JSON for AJAX if edit parameter is set
if ($edit_staff) {
    echo '<div id="edit_staff_data" style="display:none;">' . json_encode($edit_staff) . '</div>';
}
?>

<style>
.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
}
.form-row .form-group {
    flex: 1;
}
.form-row .form-group:last-child {
    margin-bottom: 0;
}
fieldset {
    margin-bottom: 20px;
    border: 1px solid #ddd;
    border-radius: 5px;
    padding: 15px;
}
legend {
    font-weight: bold;
    color: #333;
}

.staff-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.staff-table table {
    width: 100%;
    border-collapse: collapse;
}

.staff-table th,
.staff-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.staff-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.staff-table tr:hover {
    background: #f8f9fa;
}

.password-requirements {
    margin-top: 5px;
    font-size: 14px;
}

.requirement {
    display: flex;
    justify-content: space-between;
    margin-bottom: 2px;
}

.requirement .check {
    font-weight: bold;
}

.requirement.met .check {
    color: green;
}

.requirement.not-met .check {
    color: red;
}

.header-container {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.search-container {
    display: flex;
    align-items: center;
    gap: 10px;
}

.search-container input {
    padding: 10px;
    border: 1px solid #ced4da;
    border-radius: 4px;
    font-size: 14px;
    width: 250px;
}

.search-container button {
    padding: 10px 15px;
    background-color: #007bff;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}

.search-container button:hover {
    background-color: #0056b3;
}
</style>

<div class="header-container">
    <h2>Manage Staff</h2>
    <div class="search-container">
        <form method="get" action="manage_staff.php" style="display: inline;">
            <input type="text" id="search" name="search" value="<?php echo htmlspecialchars($search_filter); ?>" placeholder="Enter staff name..." style="padding: 10px; border: 1px solid #ced4da; border-radius: 4px; font-size: 14px; width: 250px;">
            <button type="submit" class="btn btn-primary" style="margin-left: 10px;">Search</button>
        </form>
    </div>
</div>

<?php if ($message): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert" style="font-size: 18px; font-weight: bold;">
        <?php echo htmlspecialchars($message); ?>
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
<?php endif; ?>

<!-- Button to trigger add modal -->
<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addStaffModal">Add New Staff</button>
<a href="print_staff.php" class="btn btn-info" target="_blank">Print Staff List</a>

<!-- Filters -->
<div style="margin: 20px 0; padding: 15px; background: #f8f9fa; border-radius: 5px;">
    <form method="get" action="manage_staff.php" style="display: flex; gap: 15px; align-items: center; flex-wrap: wrap;">
        <div style="display: flex; gap: 15px; align-items: center;">
            <label for="department_filter" style="font-weight: bold;">🏢 Filter by Department:</label>
            <select id="department_filter" name="department" style="padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                <option value="">All Departments</option>
                <?php foreach ($levels as $level): ?>
                    <option value="<?php echo htmlspecialchars($level['name']); ?>" <?php echo ($department_filter === $level['name']) ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($level['name']); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">Apply Filters</button>
        <?php if (!empty($department_filter) || !empty($search_filter)): ?>
            <a href="manage_staff.php" class="btn btn-outline-secondary">Clear All Filters</a>
        <?php endif; ?>
    </form>
</div>

<!-- Add Staff Modal -->
<div class="modal fade" id="addStaffModal" tabindex="-1" role="dialog" aria-labelledby="addStaffModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addStaffModalLabel">Add New Staff</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="manage_staff.php" enctype="multipart/form-data" id="addStaffForm">
                    <fieldset>
                        <legend>Login Credentials</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="username">👤 Username:</label>
                                <input type="text" id="username" name="username" required>
                            </div>
                            <div class="form-group">
                                <label for="password">🔒 Password:</label>
                                <input type="password" id="password" name="password" required>
                                <div id="password-requirements" class="password-requirements">
                                    <div id="req-length" class="requirement">At least 8 characters <span class="check">✗</span></div>
                                    <div id="req-uppercase" class="requirement">One uppercase letter <span class="check">✗</span></div>
                                    <div id="req-lowercase" class="requirement">One lowercase letter <span class="check">✗</span></div>
                                    <div id="req-number" class="requirement">One number <span class="check">✗</span></div>
                                    <div id="req-special" class="requirement">One special character <span class="check">✗</span></div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="confirm_password">🔒 Confirm Password:</label>
                                <input type="password" id="confirm_password" name="confirm_password" required>
                                <div id="confirm-password-match" class="password-requirements">
                                    <div id="req-match" class="requirement">Passwords match <span class="check">✗</span></div>
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="role">🎭 Role:</label>
                                <select id="role" name="role" required>
                                    <option value="">Select Role</option>
                                    <option value="teaching">Teaching</option>
                                    <option value="non-teaching">Non-teaching</option>
                                    <option value="accountant">Accountant</option>
                                    <option value="head_teacher">Head Teacher</option>
                                    <option value="director">Director</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Bio Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="first_name">👤 First Name:</label>
                                <input type="text" id="first_name" name="first_name" required>
                            </div>
                            <div class="form-group">
                                <label for="middle_name">👤 Middle Name:</label>
                                <input type="text" id="middle_name" name="middle_name">
                            </div>
                            <div class="form-group">
                                <label for="last_name">👤 Last Name:</label>
                                <input type="text" id="last_name" name="last_name" required>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="dob">📅 Date of Birth:</label>
                                <input type="date" id="dob" name="dob">
                            </div>
                            <div class="form-group">
                                <label for="gender">⚧ Gender:</label>
                                <select id="gender" name="gender">
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Contact Information</legend>
                        <div class="form-group">
                            <label for="address">🏠 Address:</label>
                            <textarea id="address" name="address"></textarea>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="email">📧 Email:</label>
                                <input type="email" id="email" name="email">
                            </div>
                            <div class="form-group">
                                <label for="phone">📞 Phone:</label>
                                <input type="text" id="phone" name="phone">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="ghana_card_number">🆔 Ghana Card Number:</label>
                                <input type="text" id="ghana_card_number" name="ghana_card_number" maxlength="20">
                            </div>
                            <div class="form-group">
                                <label for="profile_image">📸 Profile Image:</label>
                                <input type="file" id="profile_image" name="profile_image" accept="image/*">
                                <small>Accepted formats: JPG, JPEG, PNG, GIF. Max size: 5MB</small>
                                <div id="add_photo_preview" style="margin-top: 10px; display: none;">
                                    <img id="add_preview_img" src="" alt="Preview" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;">
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="qualification">🎓 Qualification:</label>
                                <input type="text" id="qualification" name="qualification">
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Professional Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="job_position">💼 Position:</label>
                                <input type="text" id="job_position" name="job_position">
                            </div>
                            <div class="form-group">
                                <label for="staff_rank">🏆 Rank:</label>
                                <input type="text" id="staff_rank" name="staff_rank">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="department">🏢 Department:</label>
                                <select id="department" name="department">
                                    <option value="">Select Department</option>
                                    <?php foreach ($levels as $level): ?>
                                        <option value="<?php echo htmlspecialchars($level['name']); ?>"><?php echo htmlspecialchars($level['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="hire_date">📅 Hire Date:</label>
                                <input type="date" id="hire_date" name="hire_date">
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" form="addStaffForm" name="add_staff" class="btn btn-primary">Add Staff</button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Staff Modal -->
<div class="modal fade" id="editStaffModal" tabindex="-1" role="dialog" aria-labelledby="editStaffModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editStaffModalLabel">Edit Staff</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="post" action="manage_staff.php" enctype="multipart/form-data" id="editStaffForm">
                    <input type="hidden" name="staff_id" id="edit_staff_id">
                    <input type="hidden" name="current_profile_image" id="edit_current_profile_image">
                    <fieldset>
                        <legend>Login Credentials</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_username">👤 Username:</label>
                                <input type="text" id="edit_username" name="username" required>
                            </div>
                            <div class="form-group">
                                <label for="edit_password">🔒 New Password (leave blank to keep current):</label>
                                <input type="password" id="edit_password" name="password">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_role">🎭 Role:</label>
                                <select id="edit_role" name="role" required>
                                    <option value="teaching">Teaching</option>
                                    <option value="non-teaching">Non-teaching</option>
                                    <option value="accountant">Accountant</option>
                                    <option value="head_teacher">Head Teacher</option>
                                    <option value="director">Director</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Bio Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_first_name">👤 First Name:</label>
                                <input type="text" id="edit_first_name" name="first_name" required>
                            </div>
                            <div class="form-group">
                                <label for="edit_middle_name">👤 Middle Name:</label>
                                <input type="text" id="edit_middle_name" name="middle_name">
                            </div>
                            <div class="form-group">
                                <label for="edit_last_name">👤 Last Name:</label>
                                <input type="text" id="edit_last_name" name="last_name" required>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_dob">📅 Date of Birth:</label>
                                <input type="date" id="edit_dob" name="dob">
                            </div>
                            <div class="form-group">
                                <label for="edit_gender">⚧ Gender:</label>
                                <select id="edit_gender" name="gender">
                                    <option value="">Select Gender</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Contact Information</legend>
                        <div class="form-group">
                            <label for="edit_address">🏠 Address:</label>
                            <textarea id="edit_address" name="address"></textarea>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_email">📧 Email:</label>
                                <input type="email" id="edit_email" name="email">
                            </div>
                            <div class="form-group">
                                <label for="edit_phone">📞 Phone:</label>
                                <input type="text" id="edit_phone" name="phone">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_ghana_card_number">🆔 Ghana Card Number:</label>
                                <input type="text" id="edit_ghana_card_number" name="ghana_card_number" maxlength="20">
                            </div>
                            <div class="form-group">
                                <label for="edit_profile_image">📸 Profile Image:</label>
                                <div id="current_photo_container" style="margin-bottom: 10px;">
                                    <img id="edit_current_photo" src="" alt="Current Photo" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%; display: none;">
                                </div>
                                <input type="file" id="edit_profile_image" name="profile_image" accept="image/*">
                                <small>Accepted formats: JPG, JPEG, PNG, GIF. Max size: 5MB</small>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_qualification">🎓 Qualification:</label>
                                <input type="text" id="edit_qualification" name="qualification">
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Professional Information</legend>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_job_position">💼 Position:</label>
                                <input type="text" id="edit_job_position" name="job_position">
                            </div>
                            <div class="form-group">
                                <label for="edit_staff_rank">🏆 Rank:</label>
                                <input type="text" id="edit_staff_rank" name="staff_rank">
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="edit_department">🏢 Department:</label>
                                <select id="edit_department" name="department">
                                    <option value="">Select Department</option>
                                    <?php foreach ($levels as $level): ?>
                                        <option value="<?php echo htmlspecialchars($level['name']); ?>"><?php echo htmlspecialchars($level['name']); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="edit_hire_date">📅 Hire Date:</label>
                                <input type="date" id="edit_hire_date" name="hire_date">
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="submit" form="editStaffForm" name="edit_staff" class="btn btn-primary">Update Staff</button>
            </div>
        </div>
    </div>
</div>



<h3>All Staff</h3>

<table class="staff-table">
    <thead>
        <tr>
            <th>Photo</th>
            <th>Staff ID</th>
            <th>Role</th>
            <th>Name</th>
            <th>Position</th>
            <th>Gender</th>
            <th>Rank</th>
            <th>Phone</th>
            <th>Email</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($staff as $member): ?>
            <tr>
                <td>
                    <?php if (!empty($member['profile_image'])): ?>
                        <img src="../<?php echo htmlspecialchars($member['profile_image']); ?>" alt="Profile Photo" style="width: 50px; height: 50px; object-fit: cover; border-radius: 50%;">
                    <?php else: ?>
                        <div style="width: 50px; height: 50px; background: #e9ecef; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #6c757d; font-weight: bold;">
                            <?php echo htmlspecialchars(substr($member['first_name'], 0, 1) . substr($member['last_name'], 0, 1)); ?>
                        </div>
                    <?php endif; ?>
                </td>
                <td><?php echo htmlspecialchars($member['staff_id'] ?? 'N/A'); ?></td>
                <td><?php echo htmlspecialchars(ucfirst($member['role'])); ?></td>
                <td><?php echo htmlspecialchars(trim(($member['last_name'] ?? '') . ' ' . ($member['middle_name'] ?? '') . ' ' . ($member['first_name'] ?? ''))); ?></td>
                <td><?php echo htmlspecialchars($member['job_position'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($member['gender'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($member['staff_rank'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($member['phone'] ?? ''); ?></td>
                <td><?php echo htmlspecialchars($member['email'] ?? ''); ?></td>
                <td>
                    <button type="button" class="btn btn-sm btn-success" onclick="editStaff(<?php echo $member['id']; ?>)">Edit</button>
                    <form method="post" action="manage_staff.php" style="display:inline;">
                        <input type="hidden" name="staff_id" value="<?php echo $member['id']; ?>">
                        <button type="submit" name="delete_staff" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script>
function editStaff(staffId) {
    // Fetch staff data via AJAX
    fetch('manage_staff.php?edit=' + staffId)
        .then(response => response.text())
        .then(html => {
            // Parse the HTML to extract staff data (this is a simple approach)
            // In a real scenario, you'd want to return JSON from the server
            const parser = new DOMParser();
            const doc = parser.parseFromString(html, 'text/html');
            const editStaffData = doc.querySelector('#edit_staff_data');
            if (editStaffData) {
                const data = JSON.parse(editStaffData.textContent);
                populateEditModal(data);
            }
        })
        .catch(error => console.error('Error fetching staff data:', error));
}

function populateEditModal(staff) {
    document.getElementById('edit_staff_id').value = staff.id;
    document.getElementById('edit_current_profile_image').value = staff.profile_image || '';
    document.getElementById('edit_username').value = staff.username || '';
    document.getElementById('edit_role').value = staff.role || '';
    document.getElementById('edit_first_name').value = staff.first_name || '';
    document.getElementById('edit_middle_name').value = staff.middle_name || '';
    document.getElementById('edit_last_name').value = staff.last_name || '';
    document.getElementById('edit_dob').value = staff.dob || '';
    document.getElementById('edit_gender').value = staff.gender || '';
    document.getElementById('edit_address').value = staff.address || '';
    document.getElementById('edit_email').value = staff.email || '';
    document.getElementById('edit_phone').value = staff.phone || '';
    document.getElementById('edit_ghana_card_number').value = staff.ghana_card_number || '';
    // Do not set value for file input
    document.getElementById('edit_qualification').value = staff.qualification || '';
    document.getElementById('edit_job_position').value = staff.job_position || '';
    document.getElementById('edit_staff_rank').value = staff.staff_rank || '';
    document.getElementById('edit_hire_date').value = staff.hire_date || '';

    // Handle current photo display
    const currentPhotoImg = document.getElementById('edit_current_photo');
    if (staff.profile_image) {
        currentPhotoImg.src = '../' + staff.profile_image;
        currentPhotoImg.style.display = 'block';
    } else {
        currentPhotoImg.style.display = 'none';
    }

    // Show the modal
    $('#editStaffModal').modal('show');
}

document.getElementById('password').addEventListener('input', function() {
    const password = this.value;
    const requirements = {
        length: password.length >= 8,
        uppercase: /[A-Z]/.test(password),
        lowercase: /[a-z]/.test(password),
        number: /\d/.test(password),
        special: /[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/.test(password)
    };

    document.getElementById('req-length').className = 'requirement ' + (requirements.length ? 'met' : 'not-met');
    document.getElementById('req-length').querySelector('.check').textContent = requirements.length ? '✓' : '✗';

    document.getElementById('req-uppercase').className = 'requirement ' + (requirements.uppercase ? 'met' : 'not-met');
    document.getElementById('req-uppercase').querySelector('.check').textContent = requirements.uppercase ? '✓' : '✗';

    document.getElementById('req-lowercase').className = 'requirement ' + (requirements.lowercase ? 'met' : 'not-met');
    document.getElementById('req-lowercase').querySelector('.check').textContent = requirements.lowercase ? '✓' : '✗';

    document.getElementById('req-number').className = 'requirement ' + (requirements.number ? 'met' : 'not-met');
    document.getElementById('req-number').querySelector('.check').textContent = requirements.number ? '✓' : '✗';

    document.getElementById('req-special').className = 'requirement ' + (requirements.special ? 'met' : 'not-met');
    document.getElementById('req-special').querySelector('.check').textContent = requirements.special ? '✓' : '✗';
});

// Add event listener for confirm password field
document.getElementById('confirm_password').addEventListener('input', function() {
    const password = document.getElementById('password').value;
    const confirmPassword = this.value;
    const match = password === confirmPassword && password !== '';

    document.getElementById('req-match').className = 'requirement ' + (match ? 'met' : 'not-met');
    document.getElementById('req-match').querySelector('.check').textContent = match ? '✓' : '✗';
});

// Add event listener for profile image preview in add modal
document.getElementById('profile_image').addEventListener('change', function(event) {
    const file = event.target.files[0];
    const previewImg = document.getElementById('add_preview_img');
    const previewDiv = document.getElementById('add_photo_preview');

    if (file) {
        const reader = new FileReader();
        reader.onload = function(e) {
            previewImg.src = e.target.result;
            previewDiv.style.display = 'block';
        };
        reader.readAsDataURL(file);
    } else {
        previewDiv.style.display = 'none';
    }
});
</script>

<?php
include '../includes/admin_footer.php';
?>
