<?php
require_once '../config.php';
require_once '../includes/access_control.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_level'])) {
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);

        try {
            $stmt = $pdo->prepare("INSERT INTO levels (name, description) VALUES (?, ?)");
            $stmt->execute([$name, $description]);
            $message = 'Level added successfully.';
        } catch (PDOException $e) {
            $message = 'Error adding level: ' . $e->getMessage();
        }
    } elseif (isset($_POST['edit_level'])) {
        $id = $_POST['id'];
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);

        try {
            $stmt = $pdo->prepare("UPDATE levels SET name = ?, description = ? WHERE id = ?");
            $stmt->execute([$name, $description, $id]);
            $message = 'Level updated successfully.';
        } catch (PDOException $e) {
            $message = 'Error updating level: ' . $e->getMessage();
        }
    } elseif (isset($_POST['delete_level'])) {
        $id = $_POST['id'];

        try {
            $stmt = $pdo->prepare("DELETE FROM levels WHERE id = ?");
            $stmt->execute([$id]);
            $message = 'Level deleted successfully.';
        } catch (PDOException $e) {
            $message = 'Error deleting level: ' . $e->getMessage();
        }
    }
}

// Get all levels
$stmt = $pdo->query("SELECT * FROM levels ORDER BY created_at DESC");
$levels = $stmt->fetchAll();

// Get level for edit
$edit_level = null;
if (isset($_GET['edit'])) {
    $id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM levels WHERE id = ?");
    $stmt->execute([$id]);
    $edit_level = $stmt->fetch();
}

include '../includes/admin_header.php';
?>

<h2>Manage Levels</h2>

<?php if ($message): ?>
    <div class="message"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<h3><?php echo $edit_level ? 'Edit Level' : 'Add New Level'; ?></h3>

<form method="post" action="manage_levels.php">
    <?php if ($edit_level): ?>
        <input type="hidden" name="id" value="<?php echo $edit_level['id']; ?>">
    <?php endif; ?>

    <div class="form-group">
        <label for="name">Level Name:</label>
        <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($edit_level['name'] ?? ''); ?>" placeholder="e.g., Primary, Junior High School" required>
    </div>

    <div class="form-group">
        <label for="description">Description:</label>
        <textarea id="description" name="description" rows="3"><?php echo htmlspecialchars($edit_level['description'] ?? ''); ?></textarea>
    </div>

    <button type="submit" name="<?php echo $edit_level ? 'edit_level' : 'add_level'; ?>" class="btn btn-primary">
        <?php echo $edit_level ? 'Update Level' : 'Add Level'; ?>
    </button>

    <?php if ($edit_level): ?>
        <a href="manage_levels.php" class="btn">Cancel</a>
    <?php endif; ?>
</form>

<h3>All Levels</h3>

<table>
    <thead>
        <tr>
            <th>ID</th>
            <th>Level Name</th>
            <th>Description</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($levels as $level): ?>
            <tr>
                <td><?php echo $level['id']; ?></td>
                <td><?php echo htmlspecialchars($level['name']); ?></td>
                <td><?php echo htmlspecialchars($level['description'] ?? ''); ?></td>
                <td>
                    <a href="?edit=<?php echo $level['id']; ?>" class="btn btn-small">Edit</a>
                    <form method="post" action="manage_levels.php" style="display:inline;">
                        <input type="hidden" name="id" value="<?php echo $level['id']; ?>">
                        <button type="submit" name="delete_level" class="btn btn-small btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
include '../includes/admin_footer.php';
?>
