<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit();
}

// Get user information
try {
    $stmt = $pdo->prepare("SELECT username, role FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch();
} catch (PDOException $e) {
    $user = ['username' => 'Unknown', 'role' => 'Unknown'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Accounting System - School Management</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../css/accounts_custom.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .accounts-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 15px 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 1000;
        }

        .accounts-header-content {
            display: flex;
            justify-content: space-between;
            align-items: center;
            max-width: 1400px;
            margin: 0 auto;
        }

        .accounts-header-left {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .accounts-logo {
            font-size: 1.5em;
            font-weight: bold;
            color: white;
            text-decoration: none;
        }

        .accounts-logo i {
            margin-right: 10px;
        }

        .accounts-breadcrumb {
            font-size: 0.9em;
            color: rgba(255,255,255,0.8);
        }

        .accounts-header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 10px;
            color: white;
        }

        .user-info i {
            font-size: 1.2em;
        }

        .logout-btn {
            background: rgba(255,255,255,0.2);
            color: white;
            padding: 8px 16px;
            border: 1px solid rgba(255,255,255,0.3);
            border-radius: 5px;
            text-decoration: none;
            transition: all 0.2s;
        }

        .logout-btn:hover {
            background: rgba(255,255,255,0.3);
            color: white;
        }

        .main-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px;
        }

        @media (max-width: 768px) {
            .accounts-header-content {
                flex-direction: column;
                gap: 15px;
            }

            .accounts-header-left,
            .accounts-header-right {
                flex-direction: column;
                gap: 10px;
            }
        }
    </style>
</head>
<body>
    <header class="accounts-header">
        <div class="accounts-header-content">
            <div class="accounts-header-left">
                <a href="index.php" class="accounts-logo">
                    <i class="fas fa-chart-line"></i>
                    School Accounting
                </a>
                <div class="accounts-breadcrumb">
                    <i class="fas fa-home"></i>
                    Financial Management System
                </div>
            </div>
            <div class="accounts-header-right">
                <div class="user-info">
                    <i class="fas fa-user"></i>
                    <span><?php echo htmlspecialchars($user['username']); ?> (<?php echo htmlspecialchars($user['role']); ?>)</span>
                </div>
                <a href="../logout.php" class="logout-btn">
                    <i class="fas fa-sign-out-alt"></i>
                    Logout
                </a>
            </div>
        </div>
    </header>

    <main class="main-content">
