<?php
require_once '../config.php';

if (!isset($_GET['teacher_id'])) {
    echo json_encode([]);
    exit;
}

$teacher_id = $_GET['teacher_id'];

try {
    // Use teacher_courses table instead of courses.teacher_id
    $stmt = $pdo->prepare("
        SELECT c.id, c.name
        FROM courses c
        JOIN teacher_courses tc ON c.id = tc.course_id
        WHERE tc.teacher_id = ?
        ORDER BY c.name
    ");
    $stmt->execute([$teacher_id]);
    $courses = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($courses);
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
