<?php
require_once '../config.php';

// Fetch total counts
$total_students = $pdo->query("SELECT COUNT(*) FROM students")->fetchColumn();
$total_teachers = $pdo->query("SELECT COUNT(*) FROM staff WHERE role = 'teaching'")->fetchColumn();
$total_courses = $pdo->query("SELECT COUNT(*) FROM courses")->fetchColumn();

// Fetch grades distribution
$grades_stmt = $pdo->query("SELECT grade, COUNT(*) as count FROM grades GROUP BY grade");
$grades_distribution = $grades_stmt->fetchAll();

include '../includes/admin_header.php';
?>

<h2>System Reports</h2>

<div class="report-summary">
    <p>Total Students: <?php echo $total_students; ?></p>
    <p>Total Teachers: <?php echo $total_teachers; ?></p>
    <p>Total Courses: <?php echo $total_courses; ?></p>
</div>

<h3>Grades Distribution</h3>
<table>
    <thead>
        <tr>
            <th>Grade</th>
            <th>Count</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($grades_distribution as $row): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['grade']); ?></td>
                <td><?php echo $row['count']; ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
include '../includes/admin_footer.php';
?>
