<?php
require_once '../config.php';

try {
    echo "Running simple chart of accounts migration...\n";

    // Check if show_in_balance_sheet column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM chart_of_accounts LIKE 'show_in_balance_sheet'");
    if ($stmt->rowCount() == 0) {
        echo "Adding show_in_balance_sheet column...\n";
        $pdo->exec("ALTER TABLE chart_of_accounts ADD COLUMN show_in_balance_sheet TINYINT(1) NULL DEFAULT 1");
    } else {
        echo "show_in_balance_sheet column already exists.\n";
    }

    // Check if created_by column exists
    $stmt = $pdo->query("SHOW COLUMNS FROM chart_of_accounts LIKE 'created_by'");
    if ($stmt->rowCount() == 0) {
        echo "Adding created_by column...\n";
        $pdo->exec("ALTER TABLE chart_of_accounts ADD COLUMN created_by INT NULL");
    } else {
        echo "created_by column already exists.\n";
    }

    // Update existing accounts with default values
    echo "Updating existing accounts with default values...\n";
    $pdo->exec("UPDATE chart_of_accounts SET show_in_balance_sheet = 1 WHERE show_in_balance_sheet IS NULL");
    $pdo->exec("UPDATE chart_of_accounts SET created_by = 1 WHERE created_by IS NULL");

    echo "Migration completed successfully!\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
