<?php
// Generate logo HTML if logo path exists
$logoHtml = '';
if (!empty($school_settings['logo_path']) && file_exists('../' . $school_settings['logo_path'])) {
    $logoHtml = '<img src="../' . htmlspecialchars($school_settings['logo_path']) . '" alt="School Logo" class="school-logo">';
}

$schoolHeaderHtml = '
<div class="school-header">
    ' . $logoHtml . '
    <div class="school-name">' . htmlspecialchars($school_settings['school_name'] ?? 'School Management System') . '</div>
    <div class="school-details">
        ' . (!empty($school_settings['address']) ? '<p><i class="fas fa-map-marker-alt"></i> ' . htmlspecialchars($school_settings['address']) . '</p>' : '') . '
        ' . (!empty($school_settings['phone']) ? '<p><i class="fas fa-phone"></i> ' . htmlspecialchars($school_settings['phone']) . '</p>' : '') . '
        ' . (!empty($school_settings['email']) ? '<p><i class="fas fa-envelope"></i> ' . htmlspecialchars($school_settings['email']) . '</p>' : '') . '
        ' . (!empty($school_settings['website']) ? '<p><i class="fas fa-globe"></i> ' . htmlspecialchars($school_settings['website']) . '</p>' : '') . '
    </div>
</div>
';

echo addslashes($schoolHeaderHtml); // Escape for JS
?>
