<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
require_once '../config.php';

$message = '';
$message_type = '';

// Fetch all staff from unified staff table
// Handle form submission for adding/editing loans
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? null;
    $staff_id = $_POST['staff_id'] ?? null;
    // Get staff_type from staff table based on staff_id
    $staff_type = '';
    if ($staff_id) {
        $stmt = $pdo->prepare("SELECT role FROM staff WHERE id = ?");
        $stmt->execute([$staff_id]);
        $staff = $stmt->fetch();
        $staff_type = $staff['role'] ?? '';
    }
    $loan_amount = $_POST['loan_amount'] ?? 0;
    $interest_rate = $_POST['interest_rate'] ?? 0;
    $repayment_period_months = $_POST['repayment_period_months'] ?? 1;
    $purpose = $_POST['purpose'] ?? '';
    $start_date = $_POST['start_date'] ?? date('Y-m-d');
    $end_date = date('Y-m-d', strtotime("+$repayment_period_months months", strtotime($start_date)));

    // Calculate monthly installment (simple interest)
    $total_interest = ($loan_amount * $interest_rate * $repayment_period_months) / (12 * 100);
    $total_payable = $loan_amount + $total_interest;
    $monthly_installment = $total_payable / $repayment_period_months;

    try {
        if ($id) {
            // Update existing loan
            $stmt = $pdo->prepare("UPDATE staff_loans SET staff_id = ?, staff_type = ?, loan_amount = ?, interest_rate = ?, repayment_period_months = ?, monthly_installment = ?, remaining_balance = ?, start_date = ?, end_date = ?, purpose = ? WHERE id = ?");
            $stmt->execute([$staff_id, $staff_type, $loan_amount, $interest_rate, $repayment_period_months, $monthly_installment, $total_payable, $start_date, $end_date, $purpose, $id]);
            $message = "Loan updated successfully.";
        } else {
            // Insert new loan
            $stmt = $pdo->prepare("INSERT INTO staff_loans (staff_id, staff_type, loan_amount, interest_rate, repayment_period_months, monthly_installment, remaining_balance, start_date, end_date, purpose, created_by) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$staff_id, $staff_type, $loan_amount, $interest_rate, $repayment_period_months, $monthly_installment, $total_payable, $start_date, $end_date, $purpose, $_SESSION['user_id']]);
            $message = "Loan created successfully.";
        }
        $message_type = 'success';
        // Redirect to clean URL to prevent re-submission
        header('Location: ' . $_SERVER['PHP_SELF']);
        exit;
    } catch (PDOException $e) {
        $message = "Database error: " . $e->getMessage();
        $message_type = 'error';
    }
}

// Handle delete action
if (isset($_GET['delete'])) {
    $delete_id = $_GET['delete'];
    try {
        $stmt = $pdo->prepare("DELETE FROM staff_loans WHERE id = ?");
        $stmt->execute([$delete_id]);
        $message = "Loan deleted successfully.";
        $message_type = 'success';
    } catch (PDOException $e) {
        $message = "Database error: " . $e->getMessage();
        $message_type = 'error';
    }
}

// Fetch all loans
$stmt = $pdo->query("SELECT * FROM staff_loans ORDER BY created_at DESC");
$loans = $stmt->fetchAll();

// Fetch all staff from unified staff table
$stmt = $pdo->query("SELECT id, CONCAT(first_name, ' ', last_name) AS name, role FROM staff ORDER BY first_name, last_name");
$staff_list = $stmt->fetchAll();

include 'includes/accounting_header.php';
?>

<h2>Manage Staff Loans</h2>

<?php if ($message): ?>
    <div class="message <?php echo $message_type; ?>"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<button type="button" class="btn btn-primary mb-3" data-toggle="modal" data-target="#addLoanModal">Add New Loan</button>

<table class="table table-striped">
    <thead>
        <tr>
            <th>ID</th>
            <th>Staff Type</th>
            <th>Staff Name</th>
            <th>Loan Amount</th>
            <th>Interest Rate (%)</th>
            <th>Repayment Period (months)</th>
            <th>Monthly Installment</th>
            <th>Remaining Balance</th>
            <th>Start Date</th>
            <th>End Date</th>
            <th>Purpose</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($loans as $loan): ?>
            <?php
                $staff_name = 'Unknown';
                foreach ($staff_list as $staff) {
                    if ($staff['id'] == $loan['staff_id']) {
                        $staff_name = $staff['name'];
                        break;
                    }
                }
            ?>
            <tr>
                <td><?php echo $loan['id']; ?></td>
                <td><?php echo ucfirst(str_replace('_', ' ', $loan['staff_type'])); ?></td>
                <td><?php echo htmlspecialchars($staff_name); ?></td>
                <td><?php echo number_format($loan['loan_amount'], 2); ?></td>
                <td><?php echo number_format($loan['interest_rate'], 2); ?></td>
                <td><?php echo $loan['repayment_period_months']; ?></td>
                <td><?php echo number_format($loan['monthly_installment'], 2); ?></td>
                <td><?php echo number_format($loan['remaining_balance'], 2); ?></td>
                <td><?php echo $loan['start_date']; ?></td>
                <td><?php echo $loan['end_date']; ?></td>
                <td><?php echo htmlspecialchars($loan['purpose']); ?></td>
                <td>
                    <button type="button" class="btn btn-sm btn-warning" onclick="editLoan(<?php echo $loan['id']; ?>)">Edit</button>
                    <a href="?delete=<?php echo $loan['id']; ?>" onclick="return confirm('Are you sure you want to delete this loan?');" class="btn btn-sm btn-danger">Delete</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php
// If editing, fetch loan data
$edit_loan = null;
if (isset($_GET['edit'])) {
    $edit_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM staff_loans WHERE id = ?");
    $stmt->execute([$edit_id]);
    $edit_loan = $stmt->fetch();
}
?>

<!-- Modal for Add/Edit Loan -->
<div class="modal fade" id="addLoanModal" tabindex="-1" role="dialog" aria-labelledby="addLoanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addLoanModalLabel"><?php echo $edit_loan ? 'Edit Loan' : 'Add New Loan'; ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form method="POST" action="" class="form-row">
                    <?php if ($edit_loan): ?>
                        <input type="hidden" name="id" value="<?php echo $edit_loan['id']; ?>">
                    <?php endif; ?>
                    <div class="col-md-6 mb-3">
                        <label for="staff_id" class="form-label">Staff Member</label>
                        <select name="staff_id" id="staff_id" class="form-select" required>
                            <option value="">Select Staff Member</option>
                            <?php foreach ($staff_list as $staff): ?>
                                <option value="<?php echo $staff['id']; ?>" <?php echo ($edit_loan && $edit_loan['staff_id'] == $staff['id']) ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($staff['name']); ?> (<?php echo ucfirst(str_replace('_', ' ', $staff['role'])); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="loan_amount" class="form-label">Loan Amount</label>
                        <input type="number" step="0.01" name="loan_amount" id="loan_amount" class="form-control" required value="<?php echo $edit_loan['loan_amount'] ?? ''; ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="interest_rate" class="form-label">Interest Rate (%)</label>
                        <input type="number" step="0.01" name="interest_rate" id="interest_rate" class="form-control" required value="<?php echo $edit_loan['interest_rate'] ?? '0.00'; ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="repayment_period_months" class="form-label">Repayment Period (months)</label>
                        <input type="number" name="repayment_period_months" id="repayment_period_months" class="form-control" required value="<?php echo $edit_loan['repayment_period_months'] ?? '1'; ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" name="start_date" id="start_date" class="form-control" required value="<?php echo $edit_loan['start_date'] ?? date('Y-m-d'); ?>">
                    </div>

                    <div class="col-md-12 mb-3">
                        <label for="purpose" class="form-label">Purpose</label>
                        <textarea name="purpose" id="purpose" class="form-control" rows="3"><?php echo $edit_loan['purpose'] ?? ''; ?></textarea>
                    </div>

                    <div class="col-12">
                        <button type="submit" class="btn btn-primary w-100"><?php echo $edit_loan ? 'Update Loan' : 'Add Loan'; ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    function editLoan(loanId) {
        window.location.href = '?edit=' + loanId;
    }
</script>

<?php include 'includes/accounting_footer.php'; ?>
