<?php
require_once '../config.php';

$message = '';
$message_type = '';

// Handle messages from redirects
if (isset($_GET['message']) && isset($_GET['type'])) {
    $message = $_GET['message'];
    $message_type = $_GET['type'];
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_deduction'])) {
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        $calculation_type = $_POST['calculation_type'];
        $rate = $_POST['rate'];
        $is_statutory = isset($_POST['is_statutory']) ? 1 : 0;

        $stmt = $pdo->prepare("
            INSERT INTO deduction_types (name, description, calculation_type, rate, is_statutory, is_active)
            VALUES (?, ?, ?, ?, ?, TRUE)
        ");

        if ($stmt->execute([$name, $description, $calculation_type, $rate, $is_statutory])) {
            $message = 'Deduction type added successfully.';
            $message_type = 'success';
        } else {
            $message = 'Failed to add deduction type.';
            $message_type = 'error';
        }
    } elseif (isset($_POST['edit_deduction'])) {
        $deduction_id = $_POST['deduction_id'];
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        $calculation_type = $_POST['calculation_type'];
        $rate = $_POST['rate'];
        $is_statutory = isset($_POST['is_statutory']) ? 1 : 0;

        $stmt = $pdo->prepare("
            UPDATE deduction_types
            SET name = ?, description = ?, calculation_type = ?, rate = ?, is_statutory = ?
            WHERE id = ?
        ");

        if ($stmt->execute([$name, $description, $calculation_type, $rate, $is_statutory, $deduction_id])) {
            $message = 'Deduction type updated successfully.';
            $message_type = 'success';
        } else {
            $message = 'Failed to update deduction type.';
            $message_type = 'error';
        }
    } elseif (isset($_POST['delete_deduction'])) {
        $deduction_id = $_POST['deduction_id'];

        // Soft delete by setting is_active to FALSE
        $stmt = $pdo->prepare("UPDATE deduction_types SET is_active = FALSE WHERE id = ?");
        if ($stmt->execute([$deduction_id])) {
            header("Location: manage_deductions.php?message=Deduction type deleted successfully&type=success");
            exit();
        } else {
            $message = 'Failed to delete deduction type.';
            $message_type = 'error';
        }
    }
}

// Fetch active deduction types
$stmt = $pdo->query("SELECT * FROM deduction_types WHERE is_active = TRUE ORDER BY name");
$deductions = $stmt->fetchAll();

// Get deduction for edit
$edit_deduction = null;
if (isset($_GET['edit'])) {
    $deduction_id = $_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM deduction_types WHERE id = ?");
    $stmt->execute([$deduction_id]);
    $edit_deduction = $stmt->fetch();
}

include 'includes/accounting_header.php';
?>

<style>
.deduction-table {
    background: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin-bottom: 20px;
}

.deduction-table table {
    width: 100%;
    border-collapse: collapse;
}

.deduction-table th,
.deduction-table td {
    padding: 12px 15px;
    text-align: left;
    border-bottom: 1px solid #e9ecef;
}

.deduction-table th {
    background: #f8f9fa;
    font-weight: 600;
    color: #495057;
}

.deduction-table tr:hover {
    background: #f8f9fa;
}

.form-row {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
}

.form-row .form-group {
    flex: 1;
}

.form-group {
    display: flex;
    flex-direction: column;
}

.form-group label {
    font-weight: 600;
    margin-bottom: 5px;
    color: #333;
}

.form-group input,
.form-group select,
.form-group textarea {
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 14px;
}

.statutory-badge {
    background: #dc3545;
    color: white;
    padding: 2px 6px;
    border-radius: 3px;
    font-size: 0.8em;
    font-weight: bold;
}

.no-deductions {
    text-align: center;
    padding: 40px;
    color: #7f8c8d;
    background: #f8f9fa;
    border-radius: 8px;
    margin: 20px 0;
}

/* Button styling to match accounting sidebar theme */
.btn-primary {
    background: linear-gradient(135deg, #2E7D32 0%, #4CAF50 100%);
    border-color: #2E7D32;
    color: white;
    padding: 10px 20px;
    border-radius: 4px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #4CAF50 0%, #66BB6A 100%);
    border-color: #4CAF50;
    color: white;
    transform: translateY(-1px);
    box-shadow: 0 2px 8px rgba(46, 125, 50, 0.3);
}

.btn {
    display: inline-block;
    padding: 8px 16px;
    border-radius: 4px;
    text-decoration: none;
    font-weight: 500;
    border: 1px solid transparent;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-small {
    padding: 6px 12px;
    font-size: 0.9em;
}

.btn:hover {
    transform: translateY(-1px);
}
</style>

<h2>➖ Manage Deduction Types</h2>

<?php if ($message): ?>
    <div class="message <?php echo $message_type; ?>"><?php echo htmlspecialchars($message); ?></div>
<?php endif; ?>

<!-- Add Deduction Type Form -->
<h3>Add New Deduction Type</h3>
<form method="post" action="manage_deductions.php" id="addDeductionForm">
    <div class="form-row">
        <div class="form-group">
            <label for="name">Deduction Name:</label>
            <input type="text" id="name" name="name" required>
        </div>
        <div class="form-group">
            <label for="calculation_type">Calculation Type:</label>
            <select id="calculation_type" name="calculation_type" required>
                <option value="percentage">Percentage</option>
                <option value="fixed">Fixed Amount</option>
            </select>
        </div>
    </div>

    <div class="form-row">
        <div class="form-group">
            <label for="rate">Rate/Amount:</label>
            <input type="number" step="0.01" id="rate" name="rate" min="0" required>
            <small id="rate-help" class="form-text text-muted">Enter percentage (e.g., 5.5) or fixed amount in GH₵</small>
        </div>
        <div class="form-group">
            <label for="is_statutory">Statutory Deduction:</label>
            <input type="checkbox" id="is_statutory" name="is_statutory" value="1">
            <small class="form-text text-muted">Check if this is a mandatory government deduction</small>
        </div>
    </div>

    <div class="form-row">
        <div class="form-group" style="flex: 2;">
            <label for="description">Description:</label>
            <textarea id="description" name="description" rows="3"></textarea>
        </div>
    </div>

        <button type="submit" name="add_deduction" class="btn btn-primary">Add Deduction Type</button>
    </form>

<?php if ($edit_deduction): ?>
    <!-- Edit Deduction Type Form -->
    <h3>Edit Deduction Type</h3>
    <form method="post" action="manage_deductions.php">
        <input type="hidden" name="deduction_id" value="<?php echo $edit_deduction['id']; ?>">

        <div class="form-row">
            <div class="form-group">
                <label for="edit_name">Deduction Name:</label>
                <input type="text" id="edit_name" name="name" value="<?php echo htmlspecialchars($edit_deduction['name']); ?>" required>
            </div>
            <div class="form-group">
                <label for="edit_calculation_type">Calculation Type:</label>
                <select id="edit_calculation_type" name="calculation_type" required>
                    <option value="percentage" <?php echo $edit_deduction['calculation_type'] == 'percentage' ? 'selected' : ''; ?>>Percentage</option>
                    <option value="fixed" <?php echo $edit_deduction['calculation_type'] == 'fixed' ? 'selected' : ''; ?>>Fixed Amount</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group">
                <label for="edit_rate">Rate/Amount:</label>
                <input type="number" step="0.01" id="edit_rate" name="rate" value="<?php echo $edit_deduction['rate']; ?>" min="0" required>
                <small class="form-text text-muted">Enter percentage (e.g., 5.5) or fixed amount in GH₵</small>
            </div>
            <div class="form-group">
                <label for="edit_is_statutory">Statutory Deduction:</label>
                <input type="checkbox" id="edit_is_statutory" name="is_statutory" value="1" <?php echo $edit_deduction['is_statutory'] ? 'checked' : ''; ?>>
                <small class="form-text text-muted">Check if this is a mandatory government deduction</small>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group" style="flex: 2;">
                <label for="edit_description">Description:</label>
                <textarea id="edit_description" name="description" rows="3"><?php echo htmlspecialchars($edit_deduction['description']); ?></textarea>
            </div>
        </div>

        <button type="submit" name="edit_deduction" class="btn btn-primary">Update Deduction Type</button>
        <a href="manage_deductions.php" class="btn btn-secondary">Cancel</a>
    </form>
<?php endif; ?>

<!-- Active Deduction Types -->
<h3>Active Deduction Types</h3>

<?php if (empty($deductions)): ?>
    <div class="no-deductions">
        <h4>No Active Deduction Types</h4>
        <p>No deduction types have been set up yet. Use the form above to add the first one.</p>
    </div>
<?php else: ?>
    <table class="deduction-table">
        <thead>
            <tr>
                <th>Name</th>
                <th>Description</th>
                <th>Type</th>
                <th>Rate</th>
                <th>Statutory</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($deductions as $deduction): ?>
                <tr>
                    <td><?php echo htmlspecialchars($deduction['name']); ?></td>
                    <td><?php echo htmlspecialchars($deduction['description']); ?></td>
                    <td><?php echo ucfirst($deduction['calculation_type']); ?></td>
                    <td><?php echo $deduction['calculation_type'] == 'percentage' ? $deduction['rate'] . '%' : 'GH₵ ' . number_format($deduction['rate'], 2); ?></td>
                    <td><?php echo $deduction['is_statutory'] ? '<span class="statutory-badge">Yes</span>' : 'No'; ?></td>
                    <td>
                        <a href="?edit=<?php echo $deduction['id']; ?>" class="btn btn-primary btn-small">Edit</a>
                        <button type="button" class="btn btn-danger btn-small" onclick="openDeleteModal(<?php echo $deduction['id']; ?>, '<?php echo htmlspecialchars($deduction['name']); ?>')">Delete</button>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="modal" style="display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5);">
    <div class="modal-content" style="background-color: white; margin: 15% auto; padding: 20px; border-radius: 8px; width: 90%; max-width: 500px; box-shadow: 0 4px 15px rgba(0,0,0,0.3);">
        <h3 style="margin-top: 0; color: #dc3545;">⚠️ Confirm Deletion</h3>
        <p>Are you sure you want to delete the deduction type "<span id="deleteDeductionName"></span>"?</p>
        <p style="color: #6c757d; font-size: 0.9em;">This action cannot be undone. The deduction type will be deactivated and will no longer be available for use.</p>

        <div style="text-align: right; margin-top: 20px;">
            <button type="button" class="btn btn-secondary" onclick="closeDeleteModal()" style="margin-right: 10px;">Cancel</button>
            <form method="post" action="manage_deductions.php" style="display: inline;">
                <input type="hidden" name="deduction_id" id="deleteDeductionId">
                <button type="submit" name="delete_deduction" class="btn btn-danger">Delete Deduction Type</button>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Update rate help text based on calculation type
    function updateRateHelp(selectId, helpId) {
        const select = document.getElementById(selectId);
        const help = document.getElementById(helpId);
        if (select && help) {
            select.addEventListener('change', function() {
                if (this.value === 'percentage') {
                    help.textContent = 'Enter percentage (e.g., 5.5)';
                } else {
                    help.textContent = 'Enter fixed amount in GH₵';
                }
            });
        }
    }

    updateRateHelp('calculation_type', 'rate-help');
    updateRateHelp('edit_calculation_type', 'edit_rate_help'); // Will add id to edit form later
});

// Modal functions
function openDeleteModal(deductionId, deductionName) {
    document.getElementById('deleteDeductionId').value = deductionId;
    document.getElementById('deleteDeductionName').textContent = deductionName;
    document.getElementById('deleteModal').style.display = 'block';
}

function closeDeleteModal() {
    document.getElementById('deleteModal').style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    const modal = document.getElementById('deleteModal');
    if (event.target == modal) {
        modal.style.display = 'none';
    }
}
</script>

<?php
include '../includes/admin_footer.php';
?>
