<?php
require_once '../config.php';

try {
    // Check if '1121' exists
    $stmt = $pdo->prepare("SELECT id FROM chart_of_accounts WHERE account_code = '1121'");
    $stmt->execute();
    if ($stmt->fetch()) {
        echo "Account '1121' already exists.\n";
    } else {
        // Insert it
        $stmt = $pdo->prepare("INSERT INTO chart_of_accounts (account_code, account_name, account_type, normal_balance, description, parent_account_id) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute(['1121', 'Student Fees Receivable', 'Asset', 'debit', 'Outstanding student fees', 6]);
        echo "Inserted account '1121'.\n";
    }

    // Check if '1112' exists (Main School Bank Account)
    $stmt = $pdo->prepare("SELECT id FROM chart_of_accounts WHERE account_code = '1112'");
    $stmt->execute();
    if ($stmt->fetch()) {
        echo "Account '1112' already exists.\n";
    } else {
        // Insert it
        $stmt = $pdo->prepare("INSERT INTO chart_of_accounts (account_code, account_name, account_type, normal_balance, description, parent_account_id) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute(['1112', 'Main School Bank Account', 'Asset', 'debit', 'Main school bank account', 3]);
        echo "Inserted account '1112'.\n";
    }

    echo "✅ Accounts checked/inserted.\n";

} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
