<?php
require_once __DIR__ . '/access_control.php';
?>

<style>
    .teacher-sidebar {
        width: 280px;
        background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
        color: #fff;
        padding: 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        z-index: 1000;
        font-size: 0.85rem;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        transition: background-color 0.3s ease;
    }

    .sidebar-header {
        padding: 25px 20px 15px;
        border-bottom: 1px solid rgba(255,255,255,0.1);
        background: rgba(255,255,255,0.05);
    }

    .teacher-sidebar h3 {
        margin: 0;
        color: #fff;
        font-size: 1.3em;
        font-weight: 700;
        text-align: center;
        letter-spacing: 1.5px;
        text-transform: uppercase;
        animation: fadeInDown 0.8s ease forwards;
    }

    .sidebar-menu {
        list-style: none;
        padding: 15px 0;
        margin: 0;
    }

    .menu-item {
        margin-bottom: 5px;
    }

    .menu-link {
        color: #ecf0f1;
        text-decoration: none;
        display: flex;
        align-items: center;
        padding: 15px 20px;
        border-radius: 0;
        transition: all 0.3s ease;
        position: relative;
        border-left: 4px solid transparent;
    }

    .menu-link:hover {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        border-left-color: #f39c12;
        text-decoration: none;
    }

    .menu-link.active {
        background-color: rgba(255,255,255,0.1);
        border-left-color: #f39c12;
    }

    .menu-icon {
        font-size: 1.2em;
        margin-right: 15px;
        width: 25px;
        text-align: center;
        display: inline-block;
    }

    .menu-text {
        font-weight: 500;
        font-size: 0.95em;
        letter-spacing: 0.5px;
    }

    .logout-item .menu-link {
        margin-top: 20px;
        border-top: 1px solid rgba(255,255,255,0.1);
        padding-top: 20px;
    }

    .logout-item .menu-link:hover {
        background-color: rgba(231, 76, 60, 0.8);
        border-left-color: #e74c3c;
    }

    /* Submenu styles */
    .has-submenu .submenu {
        list-style: none;
        padding: 0;
        margin: 0;
        background-color: rgba(0,0,0,0.1);
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }

    .has-submenu .submenu-toggle {
        position: relative;
    }

    .submenu-arrow {
        margin-left: auto;
        transition: transform 0.3s ease;
    }

    .has-submenu.open .submenu-arrow {
        transform: rotate(90deg);
    }

    .has-submenu.open .submenu {
        max-height: 200px;
    }

    .submenu-link {
        color: #bdc3c7;
        text-decoration: none;
        display: block;
        padding: 10px 20px 10px 60px;
        font-size: 0.9em;
        transition: all 0.3s ease;
    }

    .submenu-link:hover {
        background-color: rgba(255,255,255,0.05);
        color: #fff;
        text-decoration: none;
    }

    .submenu-link.active {
        background-color: rgba(255,255,255,0.1);
        color: #fff;
        font-weight: 600;
    }

    /* Keyframes for animations */
    @keyframes fadeInDown {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* Responsive */
    @media (max-width: 768px) {
        .teacher-sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s;
            z-index: 999;
        }

        .teacher-sidebar.open {
            transform: translateX(0);
        }
    }
</style>

<div class="teacher-sidebar">
    <div class="sidebar-header">
        <h3>👨‍🏫 Teacher Panel</h3>
    </div>
    <ul class="sidebar-menu">
        <li class="menu-item">
            <a href="teacher_dashboard.php" class="menu-link">
                <span class="menu-icon">📊</span>
                <span class="menu-text">Dashboard</span>
            </a>
        </li>
        <li class="menu-item has-submenu">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">👨‍🎓</span>
                <span class="menu-text">Students</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="view_students.php" class="submenu-link">View My Students</a></li>
                <li><a href="enroll_students.php" class="submenu-link">Enroll Students</a></li>
            </ul>
        </li>
        <li class="menu-item">
            <a href="teacher_panel_description.html" class="menu-link">
                <span class="menu-icon">📄</span>
                <span class="menu-text">Teacher Panel Description</span>
            </a>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['assign_grades.php', 'students_performance.php', 'students_results.php', 'students_ranking.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📊</span>
                <span class="menu-text">Grades & Performance</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="assign_grades.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'assign_grades.php' ? 'active' : ''; ?>">Assign Grades</a></li>
                <li><a href="students_performance.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'students_performance.php' ? 'active' : ''; ?>">Students Performance</a></li>
                <li><a href="students_results.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'students_results.php' ? 'active' : ''; ?>">Students Results</a></li>
                <li><a href="students_ranking.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'students_ranking.php' ? 'active' : ''; ?>">Students Ranking</a></li>
            </ul>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['view_profile.php', 'view_payslip.php', 'leave_application.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">👤</span>
                <span class="menu-text">Profile & Payroll</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="view_profile.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_profile.php' ? 'active' : ''; ?>">My Profile</a></li>
                <li><a href="view_payslip.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_payslip.php' ? 'active' : ''; ?>">My Payslips</a></li>
                <li><a href="leave_application.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'leave_application.php' ? 'active' : ''; ?>">Leave Application</a></li>
            </ul>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['discussion.php', 'notifications.php', 'schedule.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">💬</span>
                <span class="menu-text">Communication & Schedule</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="discussion.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'discussion.php' ? 'active' : ''; ?>">Discussion</a></li>
                <li><a href="notifications.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'notifications.php' ? 'active' : ''; ?>">Notifications</a></li>
                <li><a href="schedule.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'schedule.php' ? 'active' : ''; ?>">Schedule</a></li>
            </ul>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['my_courses.php', 'exam_resources.php', 'course_resources.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📚</span>
                <span class="menu-text">Courses & Resources</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="my_courses.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'my_courses.php' ? 'active' : ''; ?>">My Courses</a></li>
                <li><a href="exam_resources.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'exam_resources.php' ? 'active' : ''; ?>">Exams Resources</a></li>
                <li><a href="course_resources.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'course_resources.php' ? 'active' : ''; ?>">Course/Subject Resources</a></li>
            </ul>
        </li>
        <li class="menu-item has-submenu <?php echo in_array(basename($_SERVER['PHP_SELF']), ['attendance.php', 'view_attendance.php']) ? 'open' : ''; ?>">
            <a href="#" class="menu-link submenu-toggle">
                <span class="menu-icon">📋</span>
                <span class="menu-text">Attendance</span>
                <span class="submenu-arrow">▸</span>
            </a>
            <ul class="submenu">
                <li><a href="attendance.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'attendance.php' ? 'active' : ''; ?>">Mark Attendance</a></li>
                <li><a href="view_attendance.php" class="submenu-link <?php echo basename($_SERVER['PHP_SELF']) == 'view_attendance.php' ? 'active' : ''; ?>">View Attendance</a></li>
            </ul>
        </li>
        <li class="menu-item logout-item">
            <a href="../logout.php" class="menu-link">
                <span class="menu-icon">🚪</span>
                <span class="menu-text">Logout</span>
            </a>
        </li>
    </ul>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const submenuToggles = document.querySelectorAll('.submenu-toggle');
        const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
        const teacherSidebar = document.querySelector('.teacher-sidebar');

        submenuToggles.forEach(toggle => {
            toggle.addEventListener('click', function(e) {
                e.preventDefault();
                const parentItem = this.closest('.menu-item');
                parentItem.classList.toggle('open');
            });
        });

        if (mobileMenuToggle && teacherSidebar) {
            mobileMenuToggle.addEventListener('click', function() {
                teacherSidebar.classList.toggle('open');
            });
        }
    });
</script>
