<?php
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>School Management System</title>
    <link rel="stylesheet" href="/school/css/style.css">
</head>
<body>
    <div class="container">
        <header>
            <h1>School Management System</h1>
            <nav>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <?php if ($_SESSION['role'] == 'admin'): ?>
                        <li><a href="admin/manage_students.php">Manage Students</a></li>
                        <li><a href="admin/manage_teachers.php">Manage Teachers</a></li>
                        <li><a href="admin/manage_courses.php">Manage Courses</a></li>
                        <li><a href="admin/view_reports.php">Reports</a></li>
                    <?php elseif ($_SESSION['role'] == 'teacher'): ?>
                        <li><a href="teacher/view_students.php">View Students</a></li>
                        <li><a href="teacher/assign_grades.php">Assign Grades</a></li>
                    <?php elseif ($_SESSION['role'] == 'student'): ?>
                        <li><a href="student/view_profile.php">My Profile</a></li>
                        <li><a href="student/view_grades.php">My Grades</a></li>
                    <?php endif; ?>
                    <li><a href="logout.php">Logout</a></li>
                </ul>
            </nav>
        </header>

        <main>
