<?php
require_once '../config.php';
require_once 'includes/accounting_header.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_account'])) {
        $account_code = trim($_POST['account_code']);
        $account_name = trim($_POST['account_name']);
        $account_type = $_POST['account_type'];
        $account_category = trim($_POST['account_category']);
        $normal_balance = $_POST['normal_balance'];
        $is_control_account = isset($_POST['is_control_account']) ? 1 : 0;
        $allow_manual_posting = isset($_POST['allow_manual_posting']) ? 1 : 0;
        $show_in_reports = isset($_POST['show_in_reports']) ? 1 : 0;
        $status = $_POST['status'];
        $currency = trim($_POST['currency']);
        $department = trim($_POST['department']);
        $budget_category = trim($_POST['budget_category']);
        $linked_cash_account_id = !empty($_POST['linked_cash_account_id']) ? $_POST['linked_cash_account_id'] : null;
        $parent_account_id = !empty($_POST['parent_account_id']) ? $_POST['parent_account_id'] : null;
        $description = trim($_POST['description']);

        try {
            $stmt = $pdo->prepare("INSERT INTO chart_of_accounts (
                account_code, account_name, account_type, account_category, normal_balance,
                is_control_account, allow_manual_posting, show_in_reports, status, currency,
                department, budget_category, linked_cash_account_id, parent_account_id, description
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $account_code, $account_name, $account_type, $account_category, $normal_balance,
                $is_control_account, $allow_manual_posting, $show_in_reports, $status, $currency,
                $department, $budget_category, $linked_cash_account_id, $parent_account_id, $description
            ]);
            $success_message = "Account added successfully!";
        } catch (PDOException $e) {
            $error_message = "Error adding account: " . $e->getMessage();
        }
    } elseif (isset($_POST['edit_account'])) {
        $account_id = $_POST['account_id'];
        $account_code = trim($_POST['account_code']);
        $account_name = trim($_POST['account_name']);
        $account_type = $_POST['account_type'];
        $account_category = trim($_POST['account_category']);
        $normal_balance = $_POST['normal_balance'];
        $is_control_account = isset($_POST['is_control_account']) ? 1 : 0;
        $allow_manual_posting = isset($_POST['allow_manual_posting']) ? 1 : 0;
        $show_in_reports = isset($_POST['show_in_reports']) ? 1 : 0;
        $status = $_POST['status'];
        $currency = trim($_POST['currency']);
        $department = trim($_POST['department']);
        $budget_category = trim($_POST['budget_category']);
        $linked_cash_account_id = !empty($_POST['linked_cash_account_id']) ? $_POST['linked_cash_account_id'] : null;
        $parent_account_id = !empty($_POST['parent_account_id']) ? $_POST['parent_account_id'] : null;
        $description = trim($_POST['description']);

        try {
            $stmt = $pdo->prepare("UPDATE chart_of_accounts SET
                account_code = ?, account_name = ?, account_type = ?, account_category = ?, normal_balance = ?,
                is_control_account = ?, allow_manual_posting = ?, show_in_reports = ?, status = ?, currency = ?,
                department = ?, budget_category = ?, linked_cash_account_id = ?, parent_account_id = ?, description = ?
                WHERE id = ?");
            $stmt->execute([
                $account_code, $account_name, $account_type, $account_category, $normal_balance,
                $is_control_account, $allow_manual_posting, $show_in_reports, $status, $currency,
                $department, $budget_category, $linked_cash_account_id, $parent_account_id, $description, $account_id
            ]);
            $success_message = "Account updated successfully!";
        } catch (PDOException $e) {
            $error_message = "Error updating account: " . $e->getMessage();
        }
    } elseif (isset($_POST['delete_account'])) {
        $account_id = $_POST['account_id'];

        try {
            $stmt = $pdo->prepare("DELETE FROM chart_of_accounts WHERE id = ?");
            $stmt->execute([$account_id]);
            $success_message = "Account deleted successfully!";
        } catch (PDOException $e) {
            $error_message = "Error deleting account: " . $e->getMessage();
        }
    }
}

// Get all accounts for display
$stmt = $pdo->query("SELECT * FROM chart_of_accounts ORDER BY account_code");
$accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get parent accounts for dropdown
$stmt = $pdo->query("SELECT id, account_code, account_name FROM chart_of_accounts ORDER BY account_code");
$parent_accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Get cash accounts for linked dropdown
$stmt = $pdo->query("SELECT id, account_code, account_name FROM chart_of_accounts WHERE account_type = 'Asset' AND account_category = 'Current Asset' ORDER BY account_code");
$cash_accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2><i class="fas fa-book"></i> Chart of Accounts</h2>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addAccountModal">
                    <i class="fas fa-plus"></i> Add Account
                </button>
            </div>

            <?php if (isset($success_message)): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo $success_message; ?>
                    <button type="button" class="close" data-dismiss="alert">
                        <span>&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <?php if (isset($error_message)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo $error_message; ?>
                    <button type="button" class="close" data-dismiss="alert">
                        <span>&times;</span>
                    </button>
                </div>
            <?php endif; ?>

            <!-- Accounts Table -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Accounts</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="thead-dark">
                                <tr>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Balance</th>
                                    <th>Status</th>
                                    <th>Control</th>
                                    <th>Manual Posting</th>
                                    <th>Reports</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($accounts as $account): ?>
                                    <tr data-account-id="<?php echo $account['id']; ?>">
                                        <td>
                                            <span class="editable-field" data-field="account_code" data-value="<?php echo htmlspecialchars($account['account_code']); ?>">
                                                <?php echo htmlspecialchars($account['account_code']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="editable-field" data-field="account_name" data-value="<?php echo htmlspecialchars($account['account_name']); ?>">
                                                <?php echo htmlspecialchars($account['account_name']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <select class="form-control form-control-sm editable-select" data-field="account_type" style="display: none;">
                                                <option value="Asset" <?php echo $account['account_type'] == 'Asset' ? 'selected' : ''; ?>>Asset</option>
                                                <option value="Liability" <?php echo $account['account_type'] == 'Liability' ? 'selected' : ''; ?>>Liability</option>
                                                <option value="Equity" <?php echo $account['account_type'] == 'Equity' ? 'selected' : ''; ?>>Equity</option>
                                                <option value="Revenue" <?php echo $account['account_type'] == 'Revenue' ? 'selected' : ''; ?>>Revenue</option>
                                                <option value="Expense" <?php echo $account['account_type'] == 'Expense' ? 'selected' : ''; ?>>Expense</option>
                                            </select>
                                            <span class="badge badge-<?php
                                                echo $account['account_type'] == 'Asset' ? 'success' :
                                                     ($account['account_type'] == 'Liability' ? 'warning' :
                                                     ($account['account_type'] == 'Equity' ? 'info' :
                                                     ($account['account_type'] == 'Revenue' ? 'primary' : 'secondary')));
                                            ?> editable-field" data-field="account_type" data-value="<?php echo $account['account_type']; ?>">
                                                <?php echo $account['account_type']; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <select class="form-control form-control-sm editable-select" data-field="account_category" style="display: none;">
                                                <option value="">Not Set</option>
                                                <option value="Current Asset" <?php echo $account['account_category'] == 'Current Asset' ? 'selected' : ''; ?>>Current Asset</option>
                                                <option value="Non-current Asset" <?php echo $account['account_category'] == 'Non-current Asset' ? 'selected' : ''; ?>>Non-current Asset</option>
                                                <option value="Current Liability" <?php echo $account['account_category'] == 'Current Liability' ? 'selected' : ''; ?>>Current Liability</option>
                                                <option value="Non-current Liability" <?php echo $account['account_category'] == 'Non-current Liability' ? 'selected' : ''; ?>>Non-current Liability</option>
                                                <option value="Equity" <?php echo $account['account_category'] == 'Equity' ? 'selected' : ''; ?>>Equity</option>
                                                <option value="Operating Revenue" <?php echo $account['account_category'] == 'Operating Revenue' ? 'selected' : ''; ?>>Operating Revenue</option>
                                                <option value="Operating Expense" <?php echo $account['account_category'] == 'Operating Expense' ? 'selected' : ''; ?>>Operating Expense</option>
                                            </select>
                                            <span class="editable-field" data-field="account_category" data-value="<?php echo htmlspecialchars($account['account_category'] ?: ''); ?>">
                                                <?php echo htmlspecialchars($account['account_category'] ?: 'Not Set'); ?>
                                            </span>
                                        </td>
                                        <td><?php echo number_format($account['current_balance'], 2); ?></td>
                                        <td>
                                            <select class="form-control form-control-sm editable-select" data-field="status" style="display: none;">
                                                <option value="active" <?php echo $account['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                                                <option value="inactive" <?php echo $account['status'] == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                                            </select>
                                            <span class="badge badge-<?php echo $account['status'] == 'active' ? 'success' : 'secondary'; ?> editable-field" data-field="status" data-value="<?php echo $account['status']; ?>">
                                                <?php echo ucfirst($account['status']); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <input type="checkbox" class="editable-checkbox" data-field="is_control_account" <?php echo $account['is_control_account'] ? 'checked' : ''; ?> style="display: none;">
                                            <span class="editable-field checkbox-display" data-field="is_control_account" data-value="<?php echo $account['is_control_account']; ?>">
                                                <?php if ($account['is_control_account']): ?>
                                                    <i class="fas fa-check text-success"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-times text-muted"></i>
                                                <?php endif; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <input type="checkbox" class="editable-checkbox" data-field="allow_manual_posting" <?php echo $account['allow_manual_posting'] ? 'checked' : ''; ?> style="display: none;">
                                            <span class="editable-field checkbox-display" data-field="allow_manual_posting" data-value="<?php echo $account['allow_manual_posting']; ?>">
                                                <?php if ($account['allow_manual_posting']): ?>
                                                    <i class="fas fa-check text-success"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-times text-muted"></i>
                                                <?php endif; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <input type="checkbox" class="editable-checkbox" data-field="show_in_reports" <?php echo $account['show_in_reports'] ? 'checked' : ''; ?> style="display: none;">
                                            <span class="editable-field checkbox-display" data-field="show_in_reports" data-value="<?php echo $account['show_in_reports']; ?>">
                                                <?php if ($account['show_in_reports']): ?>
                                                    <i class="fas fa-check text-success"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-times text-muted"></i>
                                                <?php endif; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline-primary" title="Edit Inline" onclick="toggleEditMode(this)">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-success" title="Save" onclick="saveInlineEdit(this)" style="display: none;">
                                                <i class="fas fa-save"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-secondary" title="Cancel" onclick="cancelInlineEdit(this)" style="display: none;">
                                                <i class="fas fa-times"></i>
                                            </button>
                                            <button class="btn btn-sm btn-outline-danger" title="Delete" onclick="deleteAccount(<?php echo $account['id']; ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add/Edit Account Modal -->
<div class="modal fade" id="addAccountModal" tabindex="-1" role="dialog" aria-labelledby="addAccountModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addAccountModalLabel">Add New Account</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="POST" id="accountForm">
                <input type="hidden" id="account_id" name="account_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_code">Account Code *</label>
                                <input type="text" class="form-control" id="account_code" name="account_code" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_name">Account Name *</label>
                                <input type="text" class="form-control" id="account_name" name="account_name" required>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_type">Account Type *</label>
                                <select class="form-control" id="account_type" name="account_type" required>
                                    <option value="">Select Type</option>
                                    <option value="Asset">Asset</option>
                                    <option value="Liability">Liability</option>
                                    <option value="Equity">Equity</option>
                                    <option value="Revenue">Revenue</option>
                                    <option value="Expense">Expense</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="account_category">Account Category</label>
                                <select class="form-control" id="account_category" name="account_category">
                                    <option value="">Select Category</option>
                                    <option value="Current Asset">Current Asset</option>
                                    <option value="Non-current Asset">Non-current Asset</option>
                                    <option value="Current Liability">Current Liability</option>
                                    <option value="Non-current Liability">Non-current Liability</option>
                                    <option value="Equity">Equity</option>
                                    <option value="Operating Revenue">Operating Revenue</option>
                                    <option value="Operating Expense">Operating Expense</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="normal_balance">Normal Balance *</label>
                                <select class="form-control" id="normal_balance" name="normal_balance" required>
                                    <option value="">Select Balance</option>
                                    <option value="debit">Debit</option>
                                    <option value="credit">Credit</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" id="status" name="status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="currency">Currency</label>
                                <input type="text" class="form-control" id="currency" name="currency" value="GHS">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="department">Department</label>
                                <input type="text" class="form-control" id="department" name="department">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="budget_category">Budget Category</label>
                                <input type="text" class="form-control" id="budget_category" name="budget_category">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="linked_cash_account_id">Linked Cash Account</label>
                                <select class="form-control" id="linked_cash_account_id" name="linked_cash_account_id">
                                    <option value="">Select Cash Account</option>
                                    <?php foreach ($cash_accounts as $cash): ?>
                                        <option value="<?php echo $cash['id']; ?>">
                                            <?php echo htmlspecialchars($cash['account_code'] . ' - ' . $cash['account_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="parent_account_id">Parent Account</label>
                                <select class="form-control" id="parent_account_id" name="parent_account_id">
                                    <option value="">Select Parent Account</option>
                                    <?php foreach ($parent_accounts as $parent): ?>
                                        <option value="<?php echo $parent['id']; ?>">
                                            <?php echo htmlspecialchars($parent['account_code'] . ' - ' . $parent['account_name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea class="form-control" id="description" name="description" rows="2"></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="is_control_account" name="is_control_account">
                                <label class="form-check-label" for="is_control_account">
                                    Is Control Account
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="allow_manual_posting" name="allow_manual_posting" checked>
                                <label class="form-check-label" for="allow_manual_posting">
                                    Allow Manual Posting
                                </label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="show_in_reports" name="show_in_reports" checked>
                                <label class="form-check-label" for="show_in_reports">
                                    Show in Reports
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_account" id="submitBtn" class="btn btn-primary">Add Account</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">Confirm Delete</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this account? This action cannot be undone.
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" id="confirmDelete">Delete</button>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-fill account category based on type
document.getElementById('account_type').addEventListener('change', function() {
    const type = this.value;
    const categoryField = document.getElementById('account_category');
    if (type === 'Asset') {
        categoryField.value = 'Current Asset';
    } else if (type === 'Liability') {
        categoryField.value = 'Current Liability';
    } else if (type === 'Equity') {
        categoryField.value = 'Equity';
    } else if (type === 'Revenue') {
        categoryField.value = 'Operating Revenue';
    } else if (type === 'Expense') {
        categoryField.value = 'Operating Expense';
    }
});

// Function to edit account
function editAccount(accountId) {
    // Fetch account data via AJAX
    fetch('get_account.php?id=' + accountId)
        .then(response => response.json())
        .then(data => {
            // Populate the form with account data
            document.getElementById('account_id').value = data.id;
            document.getElementById('account_code').value = data.account_code;
            document.getElementById('account_name').value = data.account_name;
            document.getElementById('account_type').value = data.account_type;
            document.getElementById('account_category').value = data.account_category;
            document.getElementById('normal_balance').value = data.normal_balance;
            document.getElementById('status').value = data.status;
            document.getElementById('currency').value = data.currency;
            document.getElementById('department').value = data.department;
            document.getElementById('budget_category').value = data.budget_category;
            document.getElementById('linked_cash_account_id').value = data.linked_cash_account_id || '';
            document.getElementById('parent_account_id').value = data.parent_account_id || '';
            document.getElementById('description').value = data.description;
            document.getElementById('is_control_account').checked = data.is_control_account == 1;
            document.getElementById('allow_manual_posting').checked = data.allow_manual_posting == 1;
            document.getElementById('show_in_reports').checked = data.show_in_reports == 1;

            // Change modal title and button
            document.getElementById('addAccountModalLabel').textContent = 'Edit Account';
            document.getElementById('submitBtn').textContent = 'Update Account';
            document.getElementById('submitBtn').name = 'edit_account';

            // Show the modal
            $('#addAccountModal').modal('show');
        })
        .catch(error => {
            console.error('Error fetching account data:', error);
            alert('Error loading account data.');
        });
}

// Function to delete account
function deleteAccount(accountId) {
    if (confirm('Are you sure you want to delete this account? This action cannot be undone.')) {
        // Create a form to submit delete request
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="account_id" value="${accountId}">
            <input type="hidden" name="delete_account" value="1">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

// Reset modal when closed
$('#addAccountModal').on('hidden.bs.modal', function () {
    document.getElementById('accountForm').reset();
    document.getElementById('account_id').value = '';
    document.getElementById('addAccountModalLabel').textContent = 'Add New Account';
    document.getElementById('submitBtn').textContent = 'Add Account';
    document.getElementById('submitBtn').name = 'add_account';
});

// Inline editing functions
function toggleEditMode(button) {
    const row = button.closest('tr');
    const accountId = row.getAttribute('data-account-id');

    // Hide display spans and show input fields
    row.querySelectorAll('.editable-field').forEach(span => {
        span.style.display = 'none';
    });

    row.querySelectorAll('.editable-select').forEach(select => {
        select.style.display = 'inline-block';
    });

    row.querySelectorAll('.editable-checkbox').forEach(checkbox => {
        checkbox.style.display = 'inline-block';
    });

    // Show save and cancel buttons, hide edit button
    button.style.display = 'none';
    button.nextElementSibling.style.display = 'inline-block'; // Save button
    button.nextElementSibling.nextElementSibling.style.display = 'inline-block'; // Cancel button
}

function saveInlineEdit(button) {
    const row = button.closest('tr');
    const accountId = row.getAttribute('data-account-id');

    // Collect updated data
    const formData = new FormData();
    formData.append('account_id', accountId);
    formData.append('edit_account', '1');

    // Get values from input fields
    row.querySelectorAll('.editable-select, .editable-checkbox').forEach(field => {
        const fieldName = field.getAttribute('data-field');
        if (field.type === 'checkbox') {
            formData.append(fieldName, field.checked ? '1' : '0');
        } else {
            formData.append(fieldName, field.value);
        }
    });

    // Get text input values
    row.querySelectorAll('.editable-field').forEach(span => {
        const fieldName = span.getAttribute('data-field');
        if (span.querySelector('input')) {
            const input = span.querySelector('input');
            formData.append(fieldName, input.value);
        }
    });

    // Send AJAX request
    fetch(window.location.href, {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(data => {
        // Reload the page to show updated data
        location.reload();
    })
    .catch(error => {
        console.error('Error saving changes:', error);
        alert('Error saving changes. Please try again.');
    });
}

function cancelInlineEdit(button) {
    const row = button.closest('tr');

    // Reset all fields to original values
    row.querySelectorAll('.editable-field').forEach(span => {
        span.style.display = 'inline';
        // Reset any input fields within spans
        const input = span.querySelector('input');
        if (input) {
            input.value = span.getAttribute('data-value');
        }
    });

    row.querySelectorAll('.editable-select').forEach(select => {
        select.style.display = 'none';
        select.value = select.querySelector('option[selected]')?.value || '';
    });

    row.querySelectorAll('.editable-checkbox').forEach(checkbox => {
        checkbox.style.display = 'none';
        checkbox.checked = checkbox.getAttribute('data-value') === '1';
    });

    // Show edit button, hide save and cancel buttons
    const editButton = button.previousElementSibling.previousElementSibling;
    editButton.style.display = 'inline-block';
    button.previousElementSibling.style.display = 'none'; // Save button
    button.style.display = 'none'; // Cancel button
}

// Make text fields editable on click
document.addEventListener('click', function(e) {
    if (e.target.classList.contains('editable-field') && !e.target.querySelector('input')) {
        const span = e.target;
        const currentValue = span.getAttribute('data-value') || span.textContent.trim();
        const fieldName = span.getAttribute('data-field');

        // Create input field
        const input = document.createElement('input');
        input.type = 'text';
        input.value = currentValue;
        input.className = 'form-control form-control-sm';
        input.style.width = '100%';

        // Replace span content with input
        span.innerHTML = '';
        span.appendChild(input);
        input.focus();

        // Handle input events
        input.addEventListener('blur', function() {
            span.innerHTML = input.value;
            span.setAttribute('data-value', input.value);
        });

        input.addEventListener('keydown', function(e) {
            if (e.key === 'Enter') {
                input.blur();
            } else if (e.key === 'Escape') {
                span.innerHTML = currentValue;
                span.setAttribute('data-value', currentValue);
            }
        });
    }
});
</script>

<?php include 'includes/accounting_footer.php'; ?>
</body>
</html>
