<?php
require_once '../../config.php';

header('Content-Type: application/json');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Invalid asset ID']);
    exit;
}

$asset_id = $_GET['id'];

try {
    $stmt = $pdo->prepare("
        SELECT a.*, ac.name as category_name
        FROM assets a
        LEFT JOIN asset_categories ac ON a.category_id = ac.id
        WHERE a.id = ?
    ");
    $stmt->execute([$asset_id]);
    $asset = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($asset) {
        echo json_encode(['success' => true, 'asset' => $asset]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Asset not found']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>
