<?php
require_once 'config.php';

try {
    // Get school short name
    $stmt = $pdo->query("SELECT short_name FROM school_settings LIMIT 1");
    $settings = $stmt->fetch(PDO::FETCH_ASSOC);
    $short_name = $settings['short_name'] ?? 'SCHOOL';

    echo "School Short Name: {$short_name}\n\n";

    // Get all students with their student_ids
    $stmt = $pdo->query("SELECT id, CONCAT(first_name, ' ', COALESCE(middle_name, ''), ' ', last_name) as name, student_id FROM students ORDER BY id");
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "Student ID Verification:\n";
    echo "======================\n\n";

    $all_correct = true;
    foreach ($students as $student) {
        $expected_id = $short_name . str_pad($student['id'], 3, '0', STR_PAD_LEFT);
        $actual_id = $student['student_id'];

        if ($actual_id === $expected_id) {
            echo "✅ Student ID {$student['id']} ({$student['name']}): {$actual_id} ✓\n";
        } else {
            echo "❌ Student ID {$student['id']} ({$student['name']}): Expected {$expected_id}, Got {$actual_id}\n";
            $all_correct = false;
        }
    }

    echo "\n";
    if ($all_correct) {
        echo "🎉 All student IDs are correctly generated and assigned!\n";
    } else {
        echo "⚠️ Some student IDs need to be corrected.\n";
    }

    echo "\nTotal students: " . count($students) . "\n";

} catch(PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
