<?php
require_once 'config.php';

try {
    $stmt = $pdo->query('SHOW TABLES');
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    $procurement_tables = array_filter($tables, function($table) {
        return strpos($table, 'purchase_order') === 0 || strpos($table, 'supplier_invoice') === 0;
    });
    if (empty($procurement_tables)) {
        echo '<div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;">';
        echo '<h2>✅ SUCCESS!</h2>';
        echo '<p>All procurement tables have been successfully dropped.</p>';
        echo '</div>';
    } else {
        echo '<div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;">';
        echo '<h2>❌ REMAINING TABLES</h2>';
        echo '<p>Remaining procurement tables: ' . implode(', ', $procurement_tables) . '</p>';
        echo '</div>';
    }
} catch (Exception $e) {
    echo '<div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;">';
    echo '<h2>❌ ERROR!</h2>';
    echo '<p>Error checking tables: ' . $e->getMessage() . '</p>';
    echo '</div>';
}
?>
