<?php
// Simulate the UI form submission
require_once 'config.php';

// Clear any existing assignments first
$pdo->exec("UPDATE courses SET teacher_id = NULL");
$pdo->exec("DELETE FROM teacher_courses");

// Simulate form data as if submitted from the UI
$_POST = [
    'teacher_id' => '1',
    'courses' => ['1', '2'], // Selected course IDs
    'tab' => 'courses'
];

$_SERVER['REQUEST_METHOD'] = 'POST';

echo "Simulating UI form submission...\n";
echo "POST data: " . json_encode($_POST) . "\n";

// Include the assignment logic from assign_class.php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['courses'])) {
    try {
        $teacher_id = $_POST['teacher_id'];
        $selected_courses = $_POST['courses'] ?? [];

        echo "Processing assignment for teacher $teacher_id with courses: " . implode(', ', $selected_courses) . "\n";

        if (empty($selected_courses)) {
            echo "No courses selected.\n";
        } else {
            // First, remove all current assignments for this teacher
            $stmt = $pdo->prepare("UPDATE courses SET teacher_id = NULL WHERE teacher_id = ?");
            $result = $stmt->execute([$teacher_id]);
            echo "Cleared courses.teacher_id: " . ($result ? 'Success' : 'Failed') . "\n";

            // Also remove from teacher_courses table
            $stmt = $pdo->prepare("DELETE FROM teacher_courses WHERE teacher_id = ?");
            $result = $stmt->execute([$teacher_id]);
            echo "Cleared teacher_courses: " . ($result ? 'Success' : 'Failed') . "\n";

            // Then assign the selected courses
            $placeholders = str_repeat('?,', count($selected_courses) - 1) . '?';
            $stmt = $pdo->prepare("UPDATE courses SET teacher_id = ? WHERE id IN ($placeholders)");
            $params = array_merge([$teacher_id], $selected_courses);
            $result = $stmt->execute($params);
            echo "Updated courses table: " . ($result ? 'Success' : 'Failed') . "\n";

            // Also insert into teacher_courses table
            $stmt = $pdo->prepare("INSERT INTO teacher_courses (teacher_id, course_id) VALUES (?, ?)");
            $inserted = 0;
            foreach ($selected_courses as $course_id) {
                $result = $stmt->execute([$teacher_id, $course_id]);
                if ($result) $inserted++;
            }
            echo "Inserted $inserted records into teacher_courses\n";

            echo "Assignment completed successfully.\n";
        }
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage() . "\n";
    }
}

// Check final state
$stmt = $pdo->prepare("SELECT COUNT(*) FROM courses WHERE teacher_id = ?");
$stmt->execute([1]);
$courses_count = $stmt->fetchColumn();
echo "Courses assigned to teacher 1: $courses_count\n";

$stmt = $pdo->prepare("SELECT COUNT(*) FROM teacher_courses WHERE teacher_id = ?");
$stmt->execute([1]);
$tc_count = $stmt->fetchColumn();
echo "Teacher_courses records for teacher 1: $tc_count\n";
?>
