<?php
require_once 'config.php';

echo "Testing staff insertion with automatic staff_id generation...\n\n";

// Test data
$username = 'testuser' . time();
$password = password_hash('TestPass123!', PASSWORD_DEFAULT);
$role = 'teaching';
$first_name = 'Test';
$middle_name = 'User';
$last_name = 'Smith';
$dob = '1990-01-01';
$gender = 'male';
$address = '123 Test Street';
$email = 'test@example.com';
$phone = '1234567890';
$ghana_card_number = 'GHA123456789';
$qualification = 'Bachelor Degree';
$job_position = 'Teacher';
$staff_rank = 'Senior';
$hire_date = '2023-01-01';

try {
    // Insert user into staff_accounts table
    $stmt = $pdo->prepare("INSERT INTO staff_accounts (username, password, first_name, last_name, created_at) VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$username, $password, $first_name, $last_name]);
    $user_id = $pdo->lastInsertId();
    echo "Inserted into staff_accounts with user_id: $user_id\n";

    // Insert staff
    $stmt = $pdo->prepare("INSERT INTO staff (user_id, username, password, role, first_name, middle_name, last_name, dob, gender, address, email, phone, ghana_card_number, qualification, job_position, staff_rank, hire_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$user_id, $username, $password, $role, $first_name, $middle_name, $last_name, $dob, $gender, $address, $email, $phone, $ghana_card_number, $qualification, $job_position, $staff_rank, $hire_date]);
    $staff_table_id = $pdo->lastInsertId();
    echo "Inserted into staff with staff_id: $staff_table_id\n";

    // Generate and set staff_id
    $staff_id = generate_staff_id($pdo, $role);
    echo "Generated staff_id: $staff_id\n";

    $stmt = $pdo->prepare("UPDATE staff SET staff_id = ? WHERE id = ?");
    $result = $stmt->execute([$staff_id, $staff_table_id]);
    echo "Update result: " . ($result ? 'Success' : 'Failed') . "\n";

    // Verify the staff_id was set
    $stmt = $pdo->prepare("SELECT staff_id FROM staff WHERE id = ?");
    $stmt->execute([$staff_table_id]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    echo "Final staff_id in database: " . ($result['staff_id'] ?? 'NULL') . "\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

function generate_staff_id($pdo, $role) {
    // Get school short name
    $stmt = $pdo->query("SELECT short_name FROM school_settings LIMIT 1");
    $school_settings = $stmt->fetch(PDO::FETCH_ASSOC);
    $short_name = $school_settings['short_name'] ?? 'SCHOOL';
    echo "School short name: $short_name\n";

    $prefix = '';
    switch ($role) {
        case 'teaching':
            $prefix = 'T';
            break;
        case 'non-teaching':
            $prefix = 'NT';
            break;
        case 'accountant':
            $prefix = 'A';
            break;
        case 'head_teacher':
            $prefix = 'HT';
            break;
        case 'director':
            $prefix = 'DIR';
            break;
        default:
            $prefix = 'S';
    }
    echo "Role prefix: $prefix\n";

    // Get the max id for this role with the new format (short_name-prefixXXX)
    $pattern = $short_name . '-' . $prefix . '%';
    echo "Pattern: $pattern\n";
    $stmt = $pdo->prepare("SELECT MAX(CAST(SUBSTRING(staff_id, LENGTH(?) + 1) AS UNSIGNED)) as max_id FROM staff WHERE role = ? AND staff_id LIKE ?");
    $stmt->execute([$short_name . '-' . $prefix, $role, $pattern]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $max_id = $result['max_id'] ?? 0;
    echo "Max ID found: $max_id\n";
    $new_id = $max_id + 1;
    echo "New ID: $new_id\n";
    return $short_name . '-' . $prefix . str_pad($new_id, 3, '0', STR_PAD_LEFT);
}
?>
