<?php
require_once 'config.php';

// Simulate the exact POST request from the form
$_SERVER['REQUEST_METHOD'] = 'POST';
$_POST = [
    'teacher_id' => '1', // Use a real teacher ID
    'courses' => ['1', '2'], // Example course IDs
    'tab' => 'courses'
];

echo "Simulating POST request...\n";
echo "POST data: " . json_encode($_POST) . "\n";

$teacher_id = null;

// Include the assignment logic from assign_class.php
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['courses'])) {
    try {
        $teacher_id = $_POST['teacher_id'];
        $selected_courses = $_POST['courses'] ?? [];

        echo "Teacher ID: $teacher_id\n";
        echo "Selected courses: " . implode(', ', $selected_courses) . "\n";

        // First, remove all current assignments for this teacher
        $stmt = $pdo->prepare("UPDATE courses SET teacher_id = NULL WHERE teacher_id = ?");
        $result = $stmt->execute([$teacher_id]);
        echo "Remove assignments from courses: " . ($result ? 'Success' : 'Failed') . ", affected: " . $stmt->rowCount() . "\n";

        // Also remove from teacher_courses table
        $stmt = $pdo->prepare("DELETE FROM teacher_courses WHERE teacher_id = ?");
        $result = $stmt->execute([$teacher_id]);
        echo "Remove from teacher_courses: " . ($result ? 'Success' : 'Failed') . ", affected: " . $stmt->rowCount() . "\n";

        // Then assign the selected courses
        if (!empty($selected_courses)) {
            $placeholders = str_repeat('?,', count($selected_courses) - 1) . '?';
            $stmt = $pdo->prepare("UPDATE courses SET teacher_id = ? WHERE id IN ($placeholders)");
            $params = array_merge([$teacher_id], $selected_courses);
            echo "UPDATE params: " . implode(', ', $params) . "\n";
            $result = $stmt->execute($params);
            echo "Assign to courses: " . ($result ? 'Success' : 'Failed') . ", affected: " . $stmt->rowCount() . "\n";

            // Also insert into teacher_courses table
            $stmt = $pdo->prepare("INSERT INTO teacher_courses (teacher_id, course_id) VALUES (?, ?)");
            $inserted = 0;
            foreach ($selected_courses as $course_id) {
                $result = $stmt->execute([$teacher_id, $course_id]);
                if ($result) $inserted++;
                echo "Insert teacher_course ($teacher_id, $course_id): " . ($result ? 'Success' : 'Failed') . "\n";
            }
            echo "Total inserted into teacher_courses: $inserted\n";
        }

        echo "Assignment completed successfully.\n";

    } catch (Exception $e) {
        echo "Error: " . $e->getMessage() . "\n";
    }
}

// Check final state
if ($teacher_id) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM courses WHERE teacher_id = ?");
    $stmt->execute([$teacher_id]);
    $courses_count = $stmt->fetchColumn();
    echo "Final courses assigned: $courses_count\n";

    $stmt = $pdo->prepare("SELECT COUNT(*) FROM teacher_courses WHERE teacher_id = ?");
    $stmt->execute([$teacher_id]);
    $tc_count = $stmt->fetchColumn();
    echo "Final teacher_courses records: $tc_count\n";
}
?>
