<?php
require_once '../config.php';
require_once '../includes/user_activity_logger.php';

if (!in_array($_SESSION['role'], ['admin', 'teacher'])) {
    header('Location: ../dashboard.php');
    exit;
}

$message = '';
$student_id = $_GET['student_id'] ?? '';
$class_name = $_GET['class'] ?? '';
$academic_year_id = $_GET['academic_year'] ?? '';
$term_id = $_GET['term'] ?? '';

if (!$student_id || !$class_name || !$academic_year_id || !$term_id) {
    header('Location: assign_other_grades.php');
    exit;
}

// Get student information
$stmt = $pdo->prepare("SELECT CONCAT(last_name, ', ', first_name, ' ', COALESCE(middle_name, '')) as name FROM students WHERE id = ?");
$stmt->execute([$student_id]);
$student = $stmt->fetch();

if (!$student) {
    header('Location: assign_other_grades.php');
    exit;
}

// Get existing conduct grades if any
$stmt = $pdo->prepare("
    SELECT * FROM other_grades
    WHERE student_id = ? AND class_name = ? AND term_id = ? AND academic_year_id = ?
");
$stmt->execute([$student_id, $class_name, $term_id, $academic_year_id]);
$existing_grades = $stmt->fetch();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_conduct_grades'])) {
    $appearance = $_POST['appearance'] ?? '';
    $proper_handling_of_material = $_POST['proper_handling_of_material'] ?? '';
    $application_of_morning_devotion = $_POST['application_of_morning_devotion'] ?? '';
    $application_of_life_lesson = $_POST['application_of_life_lesson'] ?? '';
    $presentation_of_assignments = $_POST['presentation_of_assignments'] ?? '';
    $class_participation = $_POST['class_participation'] ?? '';
    $pe_punctuality = $_POST['pe_punctuality'] ?? '';
    $conduct = $_POST['conduct'] ?? '';
    $interest = $_POST['interest'] ?? '';
    $class_teacher_remarks = $_POST['class_teacher_remarks'] ?? '';

    try {
        if ($existing_grades) {
            // Update existing record
            $stmt = $pdo->prepare("
                UPDATE other_grades SET
                    appearance = ?,
                    proper_handling_of_material = ?,
                    application_of_morning_devotion = ?,
                    application_of_life_lesson = ?,
                    presentation_of_assignments = ?,
                    class_participation = ?,
                    pe_punctuality = ?,
                    conduct = ?,
                    interest = ?,
                    class_teacher_remarks = ?
                WHERE student_id = ? AND class_name = ? AND term_id = ? AND academic_year_id = ?
            ");
            $stmt->execute([
                $appearance, $proper_handling_of_material, $application_of_morning_devotion,
                $application_of_life_lesson, $presentation_of_assignments, $class_participation,
                $pe_punctuality, $conduct, $interest, $class_teacher_remarks,
                $student_id, $class_name, $term_id, $academic_year_id
            ]);
        } else {
            // Insert new record
            $stmt = $pdo->prepare("
                INSERT INTO other_grades (
                    student_id, class_name, appearance, proper_handling_of_material,
                    application_of_morning_devotion, application_of_life_lesson,
                    presentation_of_assignments, class_participation, pe_punctuality,
                    conduct, interest, class_teacher_remarks, term_id, academic_year_id
                ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
            ");
            $stmt->execute([
                $student_id, $class_name, $appearance, $proper_handling_of_material,
                $application_of_morning_devotion, $application_of_life_lesson,
                $presentation_of_assignments, $class_participation, $pe_punctuality,
                $conduct, $interest, $class_teacher_remarks, $term_id, $academic_year_id
            ]);
        }

        // Log activity
        UserActivityLogger::logActivity($_SESSION['user_id'], 'Saved conduct grades', "Saved conduct grades for student_id: $student_id in class: $class_name for academic_year_id: $academic_year_id, term_id: $term_id.");

        $message = "Conduct grades saved successfully.";
        header("Location: assign_other_grades.php?class=" . urlencode($class_name) . "&academic_year=$academic_year_id&term=$term_id&message=" . urlencode($message));
        exit;
    } catch (PDOException $e) {
        $message = "Error saving conduct grades: " . $e->getMessage();
    }
}

$role = $_SESSION['role'];

if ($role == 'admin') {
    include '../includes/admin_header.php';
} else {
    include '../includes/teacher_header.php';
}
?>

<style>
    .add-conduct-grades-container {
        padding: 20px;
        background-color: #f8f9fa;
        min-height: 100vh;
    }

    .page-header {
        background: linear-gradient(135deg, #8e44ad 0%, #9b59b6 100%);
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
        text-align: center;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    }

    .page-header h2 {
        margin: 0;
        font-size: 2.5em;
        font-weight: 700;
    }

    .student-info {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        margin-bottom: 30px;
    }

    .student-info h3 {
        color: #2c3e50;
        margin-bottom: 15px;
        font-size: 1.5em;
    }

    .grade-status {
        background: white;
        border-radius: 15px;
        padding: 20px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
        margin-bottom: 20px;
        text-align: center;
    }

    .grade-status h4 {
        color: #2c3e50;
        margin-bottom: 10px;
        font-size: 1.2em;
    }

    .status-assigned {
        color: #28a745;
        font-weight: 600;
        font-size: 1.1em;
    }

    .status-not-assigned {
        color: #dc3545;
        font-weight: 600;
        font-size: 1.1em;
    }

    .message {
        padding: 15px 20px;
        border-radius: 8px;
        margin-bottom: 20px;
        font-weight: 500;
        background: #d4edda;
        color: #155724;
        border: 1px solid #c3e6cb;
    }

    .error-message {
        background: #f8d7da;
        color: #721c24;
        border: 1px solid #f5c6cb;
    }

    .conduct-grades-form-container {
        background: white;
        border-radius: 15px;
        padding: 25px;
        box-shadow: 0 5px 15px rgba(0,0,0,0.08);
    }

    .conduct-grades-form-container h3 {
        color: #2c3e50;
        margin-bottom: 20px;
        font-size: 1.8em;
    }

    .form-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
    }

    .form-group label {
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 8px;
        font-size: 0.9em;
    }

    .form-group select,
    .form-group textarea {
        padding: 12px 15px;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        font-size: 1em;
        background: #fff;
        transition: border-color 0.3s ease;
    }

    .form-group select:focus,
    .form-group textarea:focus {
        outline: none;
        border-color: #8e44ad;
        box-shadow: 0 0 0 3px rgba(142, 68, 173, 0.1);
    }

    .form-group textarea {
        resize: vertical;
        min-height: 80px;
    }

    .form-actions {
        display: flex;
        gap: 15px;
        justify-content: center;
        margin-top: 30px;
    }

    .btn {
        padding: 12px 30px;
        border: none;
        border-radius: 8px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: all 0.3s ease;
    }

    .btn-primary {
        background: #8e44ad;
        color: white;
    }

    .btn-primary:hover {
        background: #7d3c98;
        transform: translateY(-1px);
    }

    .btn-secondary {
        background: #6c757d;
        color: white;
    }

    .btn-secondary:hover {
        background: #5a6268;
        transform: translateY(-1px);
    }

    .grade-options {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 10px;
        margin-top: 5px;
    }

    .grade-option {
        padding: 8px;
        border: 2px solid #e9ecef;
        border-radius: 6px;
        text-align: center;
        cursor: pointer;
        transition: all 0.3s ease;
        font-weight: 600;
    }

    .grade-option:hover {
        border-color: #8e44ad;
        background: #f8f9fa;
    }

    .grade-option.selected {
        border-color: #8e44ad;
        background: #8e44ad;
        color: white;
    }

    @media (max-width: 768px) {
        .add-conduct-grades-container {
            padding: 15px;
        }

        .page-header h2 {
            font-size: 2em;
        }

        .form-grid {
            grid-template-columns: 1fr;
        }

        .form-actions {
            flex-direction: column;
            align-items: stretch;
        }

        .grade-options {
            grid-template-columns: repeat(3, 1fr);
        }
    }
</style>

<div class="add-conduct-grades-container">
    <div class="page-header">
        <h2>📝 Conduct Grades</h2>
    </div>

    <div class="student-info">
        <h3>Student: <?php echo htmlspecialchars($student['name']); ?></h3>
        <p><strong>Class:</strong> <?php echo htmlspecialchars($class_name); ?></p>
    </div>

    <div class="grade-status">
        <h4>Conduct Grades Status</h4>
        <p class="<?php echo $existing_grades ? 'status-assigned' : 'status-not-assigned'; ?>">
            <?php echo $existing_grades ? '✓ Conduct Grades Assigned' : '✗ No Conduct Grades Assigned Yet'; ?>
        </p>
        <?php if ($existing_grades): ?>
            <p><small>Last updated: <?php echo htmlspecialchars($existing_grades['updated_at'] ?? 'N/A'); ?></small></p>
        <?php endif; ?>
    </div>

    <?php if ($message): ?>
        <div class="message <?php echo strpos($message, 'Error') === 0 ? 'error-message' : ''; ?>">
            <?php echo htmlspecialchars($message); ?>
        </div>
    <?php endif; ?>

    <div class="conduct-grades-form-container">
        <h3>Conduct Assessment</h3>

        <form id="conduct-grades-form" method="POST">
            <div class="form-grid">
                <div class="form-group">
                    <label for="appearance">Appearance:</label>
                    <select name="appearance" id="appearance">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['appearance'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['appearance'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['appearance'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['appearance'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['appearance'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['appearance'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="proper_handling_of_material">Proper Handling of Material:</label>
                    <select name="proper_handling_of_material" id="proper_handling_of_material">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['proper_handling_of_material'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="application_of_morning_devotion">Application of Morning Devotion:</label>
                    <select name="application_of_morning_devotion" id="application_of_morning_devotion">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['application_of_morning_devotion'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="presentation_of_assignments">Presentation of Assignments:</label>
                    <select name="presentation_of_assignments" id="presentation_of_assignments">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['presentation_of_assignments'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="class_participation">Class Participation:</label>
                    <select name="class_participation" id="class_participation">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['class_participation'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['class_participation'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['class_participation'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['class_participation'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['class_participation'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['class_participation'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="pe_punctuality">Punctuality:</label>
                    <select name="pe_punctuality" id="pe_punctuality">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['pe_punctuality'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="conduct">Conduct:</label>
                    <select name="conduct" id="conduct">
                        <option value="">Select Grade</option>
                        <option value="A" <?php echo ($existing_grades['conduct'] ?? '') == 'A' ? 'selected' : ''; ?>>A - Excellent</option>
                        <option value="B" <?php echo ($existing_grades['conduct'] ?? '') == 'B' ? 'selected' : ''; ?>>B - Very Good</option>
                        <option value="C" <?php echo ($existing_grades['conduct'] ?? '') == 'C' ? 'selected' : ''; ?>>C - Good</option>
                        <option value="D" <?php echo ($existing_grades['conduct'] ?? '') == 'D' ? 'selected' : ''; ?>>D - Satisfactory</option>
                        <option value="E" <?php echo ($existing_grades['conduct'] ?? '') == 'E' ? 'selected' : ''; ?>>E - Needs Improvement</option>
                        <option value="F" <?php echo ($existing_grades['conduct'] ?? '') == 'F' ? 'selected' : ''; ?>>F - Poor</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="application_of_life_lesson">Application of Life Lesson:</label>
                    <textarea name="application_of_life_lesson" id="application_of_life_lesson" placeholder="Enter comments about life lesson application..."><?php echo htmlspecialchars($existing_grades['application_of_life_lesson'] ?? ''); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="interest">Interest:</label>
                    <textarea name="interest" id="interest" placeholder="Enter comments about student's interest..."><?php echo htmlspecialchars($existing_grades['interest'] ?? ''); ?></textarea>
                </div>

                <div class="form-group">
                    <label for="class_teacher_remarks">Class Teacher Remarks:</label>
                    <textarea name="class_teacher_remarks" id="class_teacher_remarks" placeholder="Enter class teacher remarks..."><?php echo htmlspecialchars($existing_grades['class_teacher_remarks'] ?? ''); ?></textarea>
                </div>
            </div>

            <div class="form-actions">
                <button type="submit" name="save_conduct_grades" class="btn btn-primary">💾 Save Conduct Grades</button>
                <a href="assign_other_grades.php?class=<?php echo urlencode($class_name); ?>&academic_year=<?php echo $academic_year_id; ?>&term=<?php echo $term_id; ?>" class="btn btn-secondary">← Back to Students</a>
            </div>
        </form>
    </div>
</div>

<?php
if ($role == 'admin') {
    include '../includes/admin_footer.php';
} else {
    include '../includes/teacher_footer.php';
}
?>
