<?php
require_once '../config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit;
}

$user_id = $_SESSION['user_id'];

if (!isset($_GET['package_id'])) {
    header('Location: dashboard.php');
    exit;
}

$package_id = (int)$_GET['package_id'];

// Verify package exists
$stmt = $pdo->prepare("SELECT * FROM subscription_packages WHERE id = ?");
$stmt->execute([$package_id]);
$package = $stmt->fetch();

if (!$package) {
    // Package not found
    header('Location: dashboard.php?error=package_not_found');
    exit;
}

try {
    // Start transaction
    $pdo->beginTransaction();

    // Deactivate current subscription if exists
    $stmt = $pdo->prepare("UPDATE client_subscriptions SET subscription_status = 'inactive' WHERE user_id = ? AND subscription_status = 'active'");
    $stmt->execute([$user_id]);

    // Check if user already has a subscription for this package
    $stmt = $pdo->prepare("SELECT id FROM client_subscriptions WHERE user_id = ? AND package_id = ?");
    $stmt->execute([$user_id, $package_id]);
    $existing = $stmt->fetch();

    if ($existing) {
        // Update existing subscription
        $stmt = $pdo->prepare("UPDATE client_subscriptions SET subscription_status = 'active', start_date = CURDATE(), end_date = DATE_ADD(CURDATE(), INTERVAL 1 YEAR), max_students = ?, max_teachers = ?, features = ?, updated_at = CURRENT_TIMESTAMP WHERE id = ?");
        $stmt->execute([
            $package['max_students'],
            $package['max_teachers'],
            $package['features'],
            $existing['id']
        ]);
    } else {
        // Insert new subscription
        $stmt = $pdo->prepare("INSERT INTO client_subscriptions (user_id, client_name, package_id, subscription_status, start_date, end_date, max_students, max_teachers, features) VALUES (?, ?, ?, 'active', CURDATE(), DATE_ADD(CURDATE(), INTERVAL 1 YEAR), ?, ?, ?)");
        $stmt->execute([
            $user_id,
            $_SESSION['username'], // Use username as client name for simplicity
            $package_id,
            $package['max_students'],
            $package['max_teachers'],
            $package['features']
        ]);
    }

    // Commit transaction
    $pdo->commit();

    // Redirect with success
    header('Location: dashboard.php?success=activated');

} catch (Exception $e) {
    // Rollback on error
    $pdo->rollBack();
    header('Location: dashboard.php?error=activation_failed');
}
exit;
?>
