<?php
require_once 'config.php';

// Demo data for library management system
echo "<h2>Setting up Library Demo Data</h2>";

// Insert sample books
$books = [
    [
        'title' => 'To Kill a Mockingbird',
        'author' => 'Harper Lee',
        'isbn' => '978-0-06-112008-4',
        'category_id' => 1, // Fiction
        'publisher' => 'HarperCollins',
        'publication_year' => 1960,
        'total_copies' => 3,
        'available_copies' => 3,
        'description' => 'A classic novel about racial injustice and childhood innocence',
        'location' => 'Shelf A-1'
    ],
    [
        'title' => '1984',
        'author' => 'George Orwell',
        'isbn' => '978-0-452-28423-4',
        'category_id' => 1, // Fiction
        'publisher' => 'Penguin Classics',
        'publication_year' => 1949,
        'total_copies' => 2,
        'available_copies' => 2,
        'description' => 'A dystopian novel about totalitarianism and surveillance',
        'location' => 'Shelf A-2'
    ],
    [
        'title' => 'The History of Ancient Rome',
        'author' => 'Michael Grant',
        'isbn' => '978-0-684-19579-7',
        'category_id' => 4, // History
        'publisher' => 'Scribner',
        'publication_year' => 1990,
        'total_copies' => 1,
        'available_copies' => 1,
        'description' => 'Comprehensive history of ancient Rome',
        'location' => 'Shelf B-1'
    ],
    [
        'title' => 'Introduction to Physics',
        'author' => 'Richard Feynman',
        'isbn' => '978-0-201-02118-9',
        'category_id' => 3, // Science
        'publisher' => 'Addison-Wesley',
        'publication_year' => 1963,
        'total_copies' => 4,
        'available_copies' => 4,
        'description' => 'Classic physics textbook by Nobel laureate',
        'location' => 'Shelf C-1'
    ],
    [
        'title' => 'World Geography',
        'author' => 'National Geographic',
        'isbn' => '978-0-7922-5930-4',
        'category_id' => 2, // Non-Fiction
        'publisher' => 'National Geographic Society',
        'publication_year' => 2005,
        'total_copies' => 2,
        'available_copies' => 2,
        'description' => 'Comprehensive geography reference book',
        'location' => 'Shelf D-1'
    ],
    [
        'title' => 'Harry Potter and the Philosopher\'s Stone',
        'author' => 'J.K. Rowling',
        'isbn' => '978-0-7475-3269-9',
        'category_id' => 5, // Children
        'publisher' => 'Bloomsbury',
        'publication_year' => 1997,
        'total_copies' => 5,
        'available_copies' => 5,
        'description' => 'First book in the Harry Potter series',
        'location' => 'Shelf E-1'
    ],
    [
        'title' => 'The Elements of Style',
        'author' => 'William Strunk Jr.',
        'isbn' => '978-0-205-30902-3',
        'category_id' => 2, // Non-Fiction
        'publisher' => 'Longman',
        'publication_year' => 1959,
        'total_copies' => 3,
        'available_copies' => 3,
        'description' => 'Classic guide to writing well',
        'location' => 'Shelf D-2'
    ],
    [
        'title' => 'Calculus Made Easy',
        'author' => 'Silvanus P. Thompson',
        'isbn' => '978-0-312-18548-0',
        'category_id' => 3, // Science
        'publisher' => 'St. Martin\'s Press',
        'publication_year' => 1910,
        'total_copies' => 2,
        'available_copies' => 2,
        'description' => 'Accessible introduction to calculus',
        'location' => 'Shelf C-2'
    ]
];

echo "<h3>Inserting Sample Books...</h3>";
foreach ($books as $book) {
    try {
        $stmt = $pdo->prepare("
            INSERT INTO library_books
            (title, author, isbn, category_id, publisher, publication_year, total_copies, available_copies, description, location, added_by)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 1)
        ");
        $stmt->execute([
            $book['title'],
            $book['author'],
            $book['isbn'],
            $book['category_id'],
            $book['publisher'],
            $book['publication_year'],
            $book['total_copies'],
            $book['available_copies'],
            $book['description'],
            $book['location']
        ]);
        echo "✓ Added: " . $book['title'] . "<br>";
    } catch (PDOException $e) {
        echo "✗ Error adding " . $book['title'] . ": " . $e->getMessage() . "<br>";
    }
}

// Get some student IDs for borrowing records
$studentIds = [];
try {
    $stmt = $pdo->query("SELECT id FROM students LIMIT 10");
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($students as $student) {
        $studentIds[] = $student['id'];
    }
} catch (PDOException $e) {
    echo "Error getting student IDs: " . $e->getMessage() . "<br>";
}

// Insert sample borrowing records
$borrowings = [
    [
        'book_id' => 1,
        'user_id' => $studentIds[0] ?? 1,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-5 days')),
        'due_date' => date('Y-m-d', strtotime('+9 days')),
        'status' => 'borrowed'
    ],
    [
        'book_id' => 2,
        'user_id' => $studentIds[1] ?? 2,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-10 days')),
        'due_date' => date('Y-m-d', strtotime('-2 days')), // Overdue
        'status' => 'overdue'
    ],
    [
        'book_id' => 3,
        'user_id' => $studentIds[2] ?? 3,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-3 days')),
        'due_date' => date('Y-m-d', strtotime('+11 days')),
        'status' => 'borrowed'
    ],
    [
        'book_id' => 4,
        'user_id' => $studentIds[3] ?? 4,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-15 days')),
        'due_date' => date('Y-m-d', strtotime('-7 days')), // Overdue
        'status' => 'overdue'
    ],
    [
        'book_id' => 5,
        'user_id' => $studentIds[4] ?? 5,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-20 days')),
        'due_date' => date('Y-m-d', strtotime('-12 days')),
        'returned_at' => date('Y-m-d H:i:s', strtotime('-10 days')),
        'status' => 'returned'
    ],
    [
        'book_id' => 6,
        'user_id' => $studentIds[5] ?? 6,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-7 days')),
        'due_date' => date('Y-m-d', strtotime('+7 days')),
        'status' => 'borrowed'
    ],
    [
        'book_id' => 7,
        'user_id' => $studentIds[6] ?? 7,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-12 days')),
        'due_date' => date('Y-m-d', strtotime('+2 days')),
        'status' => 'borrowed'
    ],
    [
        'book_id' => 8,
        'user_id' => $studentIds[7] ?? 8,
        'borrowed_at' => date('Y-m-d H:i:s', strtotime('-25 days')),
        'due_date' => date('Y-m-d', strtotime('-17 days')),
        'returned_at' => date('Y-m-d H:i:s', strtotime('-15 days')),
        'status' => 'returned'
    ]
];

echo "<h3>Inserting Sample Borrowing Records...</h3>";
foreach ($borrowings as $borrowing) {
    try {
        $stmt = $pdo->prepare("
            INSERT INTO library_borrowings
            (book_id, user_id, borrowed_at, due_date, returned_at, status, issued_by)
            VALUES (?, ?, ?, ?, ?, ?, 1)
        ");
        $stmt->execute([
            $borrowing['book_id'],
            $borrowing['user_id'],
            $borrowing['borrowed_at'],
            $borrowing['due_date'],
            $borrowing['returned_at'] ?? null,
            $borrowing['status']
        ]);
        echo "✓ Added borrowing record for book ID " . $borrowing['book_id'] . "<br>";
    } catch (PDOException $e) {
        echo "✗ Error adding borrowing record: " . $e->getMessage() . "<br>";
    }
}

// Update available copies based on borrowings
echo "<h3>Updating Book Availability...</h3>";
try {
    $stmt = $pdo->prepare("
        UPDATE library_books
        SET available_copies = total_copies - (
            SELECT COUNT(*) FROM library_borrowings
            WHERE book_id = library_books.id
            AND status IN ('borrowed', 'overdue')
        )
    ");
    $stmt->execute();
    echo "✓ Updated book availability counts<br>";
} catch (PDOException $e) {
    echo "✗ Error updating availability: " . $e->getMessage() . "<br>";
}

echo "<h3>Demo Data Setup Complete!</h3>";
echo "<p>You can now test the library management system with sample data.</p>";
echo "<ul>";
echo "<li><a href='library/library_dashboard.php'>Library Dashboard</a></li>";
echo "<li><a href='library/search_books.php'>Search Books</a></li>";
echo "<li><a href='library/overdue_books.php'>Overdue Books</a></li>";
echo "<li><a href='library/library_reports.php'>Library Reports</a></li>";
echo "</ul>";
?>
