<?php
require_once 'config.php';

try {
    echo "Making Mobile Money Account editable...\n\n";

    // Update the Mobile Money Account to make it editable (not system account)
    $stmt = $pdo->prepare("UPDATE chart_of_accounts SET is_system_account = 0 WHERE account_name = ? AND account_type = 'Asset'");
    $stmt->execute(['Mobile Money Account']);

    $affected_rows = $stmt->rowCount();

    if ($affected_rows > 0) {
        echo "✅ Mobile Money Account is now editable!\n";
        echo "Rows affected: {$affected_rows}\n";
    } else {
        echo "⚠️ No rows were updated. Account may not exist or already editable.\n";
    }

    // Verify the account details
    $stmt = $pdo->prepare("SELECT id, account_code, account_name, account_type, is_system_account, show_in_balance_sheet FROM chart_of_accounts WHERE account_name = ? AND account_type = 'Asset'");
    $stmt->execute(['Mobile Money Account']);
    $account = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($account) {
        echo "\nAccount Details:\n";
        echo "- ID: {$account['id']}\n";
        echo "- Code: {$account['account_code']}\n";
        echo "- Name: {$account['account_name']}\n";
        echo "- Type: {$account['account_type']}\n";
        echo "- System Account: " . ($account['is_system_account'] ? 'Yes' : 'No') . "\n";
        echo "- Shows in Balance Sheet: " . ($account['show_in_balance_sheet'] ? 'Yes' : 'No') . "\n";
    } else {
        echo "Account not found.\n";
    }

} catch (Exception $e) {
    echo "❌ Error making Mobile Money Account editable: " . $e->getMessage() . "\n";
}
?>
