<?php
// This is the main logout file
require_once 'config.php';

// Get the user's role before destroying session
$user_role = isset($_SESSION['role']) ? $_SESSION['role'] : null;

// Destroy session
session_destroy();

// Redirect based on user role
if ($user_role === 'admin' || $user_role === 'super_admin' || $user_role === 'head_teacher') {
    header('Location: admin/index.php');
} elseif ($user_role === 'accountant') {
    header('Location: accounts/index.php');
} elseif ($user_role === 'teacher') {
    header('Location: teacher/index.php');
} else {
    header('Location: login.php');
}
exit;
?>
