// Submenu toggle functionality
document.addEventListener('DOMContentLoaded', function() {
    // Get all submenu toggle elements
    const submenuToggles = document.querySelectorAll('.submenu-toggle');

    submenuToggles.forEach(function(toggle) {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();

            // Get the parent menu item
            const menuItem = this.closest('.menu-item');

            // Toggle the active class
            menuItem.classList.toggle('active');

            // Close other open submenus
            const allMenuItems = document.querySelectorAll('.has-submenu');
            allMenuItems.forEach(function(item) {
                if (item !== menuItem) {
                    item.classList.remove('active');
                }
            });
        });
    });

    // Close submenus when clicking outside
    document.addEventListener('click', function(e) {
        if (!e.target.closest('.has-submenu')) {
            const allMenuItems = document.querySelectorAll('.has-submenu');
            allMenuItems.forEach(function(item) {
                item.classList.remove('active');
            });
        }
    });
});

// Example: Close modal when clicking outside of it
window.onclick = function(event) {
    var modal = document.getElementById('gradeModal');
    if (modal && event.target == modal) {
        modal.style.display = "none";
    }
};
