<?php
require_once 'config.php';

$stmt = $pdo->query('SELECT id, role FROM staff WHERE staff_id IS NULL OR staff_id = ""');
$staff_without_id = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($staff_without_id as $staff) {
    $staff_id = generate_staff_id($pdo, $staff['role']);
    $stmt_update = $pdo->prepare('UPDATE staff SET staff_id = ? WHERE id = ?');
    $stmt_update->execute([$staff_id, $staff['id']]);
    echo 'Updated staff ID for ID ' . $staff['id'] . ' to ' . $staff_id . PHP_EOL;
}

function generate_staff_id($pdo, $role) {
    $stmt = $pdo->query('SELECT short_name FROM school_settings LIMIT 1');
    $school_settings = $stmt->fetch(PDO::FETCH_ASSOC);
    $short_name = $school_settings['short_name'] ?? 'SCHOOL';

    $prefix = '';
    switch ($role) {
        case 'teaching':
            $prefix = 'T';
            break;
        case 'non-teaching':
            $prefix = 'NT';
            break;
        case 'accountant':
            $prefix = 'A';
            break;
        case 'head_teacher':
            $prefix = 'HT';
            break;
        case 'director':
            $prefix = 'DIR';
            break;
        default:
            $prefix = 'S';
    }

    $pattern = $short_name . '-' . $prefix . '%';
    $stmt = $pdo->prepare('SELECT MAX(CAST(SUBSTRING(staff_id, LENGTH(?) + 1) AS UNSIGNED)) as max_id FROM staff WHERE role = ? AND staff_id LIKE ?');
    $stmt->execute([$short_name . '-' . $prefix, $role, $pattern]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $max_id = $result['max_id'] ?? 0;
    $new_id = $max_id + 1;
    return $short_name . '-' . $prefix . str_pad($new_id, 3, '0', STR_PAD_LEFT);
}

echo 'Staff IDs updated for existing staff.';
?>
