<?php
require_once 'config.php';

try {
    // List of foreign key constraints to drop
    $constraints = [
        'accountants_logs_ibfk_1',
        'fk_user_id',
        'fk_discussion_groups_created_by',
        'fk_discussion_participants_user',
        'password_reset_tokens_ibfk_1',
        'staff_leave_applications_ibfk_1',
        'staff_leave_applications_ibfk_2',
        'user_activity_logs_ibfk_1'
    ];

    foreach ($constraints as $constraint) {
        try {
            $pdo->exec("ALTER TABLE accountants_logs DROP FOREIGN KEY $constraint");
            echo "Dropped foreign key: $constraint\n";
        } catch (Exception $e) {
            // Try to find the table name for this constraint
            $table_name = '';
            if (strpos($constraint, 'accountants_logs') !== false) $table_name = 'accountants_logs';
            elseif (strpos($constraint, 'client_subscriptions') !== false) $table_name = 'client_subscriptions';
            elseif (strpos($constraint, 'discussion_groups') !== false) $table_name = 'discussion_groups';
            elseif (strpos($constraint, 'discussion_participants') !== false) $table_name = 'discussion_participants';
            elseif (strpos($constraint, 'password_reset_tokens') !== false) $table_name = 'password_reset_tokens';
            elseif (strpos($constraint, 'staff_leave_applications') !== false) $table_name = 'staff_leave_applications';
            elseif (strpos($constraint, 'user_activity_logs') !== false) $table_name = 'user_activity_logs';

            if ($table_name) {
                try {
                    $pdo->exec("ALTER TABLE $table_name DROP FOREIGN KEY $constraint");
                    echo "Dropped foreign key: $constraint from table $table_name\n";
                } catch (Exception $e2) {
                    echo "Failed to drop $constraint: " . $e2->getMessage() . "\n";
                }
            } else {
                echo "Failed to drop $constraint: " . $e->getMessage() . "\n";
            }
        }
    }

    echo "All foreign key constraints referencing users table have been dropped.\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
