<?php
require_once 'config.php';

echo "<h1>Debug: Student 'favour' in JHS 1 Alpha</h1>";

// Check students in JHS 1 Alpha
echo "<h2>Students in class 'JHS 1 Alpha':</h2>";
$stmt = $pdo->prepare("SELECT s.id, CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as name, s.class, s.user_id, su.username, 'student' as role FROM students s JOIN student_users su ON s.user_id = su.id WHERE s.class = ?");
$stmt->execute(['JHS 1 Alpha']);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($students)) {
    echo "<p>No students found in JHS 1 Alpha.</p>";
} else {
    echo "<table border='1'><tr><th>ID</th><th>Name</th><th>Class</th><th>User ID</th><th>Username</th><th>Role</th></tr>";
    foreach ($students as $student) {
        echo "<tr><td>{$student['id']}</td><td>{$student['name']}</td><td>{$student['class']}</td><td>{$student['user_id']}</td><td>{$student['username']}</td><td>{$student['role']}</td></tr>";
    }
    echo "</table>";
}

// Check if student 'favour' exists
echo "<h2>Search for student named 'favour':</h2>";
$stmt = $pdo->prepare("SELECT s.id, CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as name, s.class, s.user_id, su.username, 'student' as role FROM students s JOIN student_users su ON s.user_id = su.id WHERE CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) LIKE ?");
$stmt->execute(['%favour%']);
$favour_students = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (empty($favour_students)) {
    echo "<p>No student named 'favour' found.</p>";
} else {
    echo "<table border='1'><tr><th>ID</th><th>Name</th><th>Class</th><th>User ID</th><th>Username</th><th>Role</th></tr>";
    foreach ($favour_students as $student) {
        echo "<tr><td>{$student['id']}</td><td>{$student['name']}</td><td>{$student['class']}</td><td>{$student['user_id']}</td><td>{$student['username']}</td><td>{$student['role']}</td></tr>";
    }
    echo "</table>";
}

// Check admin user
echo "<h2>Admin user details:</h2>";
$stmt = $pdo->prepare("SELECT id, username, role FROM staff WHERE role = 'admin' LIMIT 1");
$stmt->execute();
$admin = $stmt->fetch(PDO::FETCH_ASSOC);

if ($admin) {
    echo "<p>Admin ID: {$admin['id']}, Username: {$admin['username']}, Role: {$admin['role']}</p>";
} else {
    echo "<p>No admin user found.</p>";
}
?>
