<?php
require_once 'config.php';

echo "<h1>Debug: How Admin is Assigned to Class</h1>";

// Check the admin user in users table
echo "<h2>Admin User in users table:</h2>";
$stmt = $pdo->prepare("SELECT id, username, role FROM users WHERE role = 'admin'");
$admins = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!empty($admins)) {
    echo "<table border='1'><tr><th>ID</th><th>Username</th><th>Role</th></tr>";
    foreach ($admins as $admin) {
        echo "<tr><td>{$admin['id']}</td><td>{$admin['username']}</td><td>{$admin['role']}</td></tr>";
    }
    echo "</table>";
} else {
    echo "<p>No admin users found.</p>";
}

// Check if admin has a student record
echo "<h2>Admin's Student Record:</h2>";
$stmt = $pdo->prepare("SELECT s.id, CONCAT(s.first_name, ' ', COALESCE(s.middle_name, ''), ' ', s.last_name) as name, s.class, s.user_id, u.username FROM students s JOIN users u ON s.user_id = u.id WHERE u.role = 'admin'");
$admin_students = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!empty($admin_students)) {
    echo "<table border='1'><tr><th>Student ID</th><th>Name</th><th>Class</th><th>User ID</th><th>Username</th></tr>";
    foreach ($admin_students as $student) {
        echo "<tr><td>{$student['id']}</td><td>{$student['name']}</td><td>{$student['class']}</td><td>{$student['user_id']}</td><td>{$student['username']}</td></tr>";
    }
    echo "</table>";
    echo "<p><strong>Issue:</strong> The admin user has been incorrectly added to the students table. Admins should not be students.</p>";
} else {
    echo "<p>Admin is not in the students table (this is correct).</p>";
}

// Check if there are any scripts that might have caused this
echo "<h2>Check for potential causes:</h2>";
echo "<p>Looking for any code that might have inserted admin as student...</p>";

// Check if there's a setup script or migration that did this
$files = glob('*.php');
$setup_files = array_filter($files, function($file) {
    return strpos($file, 'setup') !== false || strpos($file, 'install') !== false || strpos($file, 'init') !== false;
});

if (!empty($setup_files)) {
    echo "<p>Potential setup files found: " . implode(', ', $setup_files) . "</p>";
} else {
    echo "<p>No obvious setup files found.</p>";
}

echo "<h2>Recommendation:</h2>";
echo "<p>Remove the admin user from the students table since admins should not be students. Use this SQL:</p>";
echo "<code>DELETE FROM students WHERE user_id = 1 AND name = '';</code>";
?>
